/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Receiver;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
@GwtCompatible
public final class Receivers {
    private static final Receiver<Object> IGNORING_RECEIVER = new Receiver<Object>(){

        @Override
        public void accept(Object object) {
        }
    };

    private Receivers() {
    }

    public static <T> Receiver<T> ignore() {
        return IGNORING_RECEIVER;
    }

    public static <T> Receiver<T> collect(final Collection<? super T> collection) {
        return new Receiver<T>(){

            @Override
            public void accept(T object) {
                collection.add(object);
            }
        };
    }

    public static <T> Receiver<T> compose(final Receiver<? super T> ... receivers) {
        return new Receiver<T>(){

            @Override
            public void accept(T object) {
                for (Receiver receiver : receivers) {
                    receiver.accept(object);
                }
            }
        };
    }

    public static <T> Receiver<T> compose(final Iterable<Receiver<T>> receivers) {
        return new Receiver<T>(){

            @Override
            public void accept(T object) {
                for (Receiver receiver : receivers) {
                    receiver.accept(object);
                }
            }
        };
    }
}

