/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedResourcesFactoryBean
implements FactoryBean<Resource[]> {
    private final Resource[] resources;

    public SortedResourcesFactoryBean(ResourceLoader resourceLoader, List<String> locations) throws IOException {
        ArrayList<Resource> scripts = new ArrayList<Resource>();
        for (String location : locations) {
            if (resourceLoader instanceof ResourcePatternResolver) {
                ArrayList resources = new ArrayList(Arrays.asList(((ResourcePatternResolver)resourceLoader).getResources(location)));
                Collections.sort(resources, new Comparator<Resource>(){

                    @Override
                    public int compare(Resource o1, Resource o2) {
                        try {
                            return o1.getURL().toString().compareTo(o2.getURL().toString());
                        }
                        catch (IOException iOException) {
                            return 0;
                        }
                    }
                });
                for (Resource resource : resources) {
                    scripts.add(resource);
                }
                continue;
            }
            scripts.add(resourceLoader.getResource(location));
        }
        this.resources = scripts.toArray(new Resource[scripts.size()]);
    }

    public Resource[] getObject() {
        return this.resources;
    }

    public Class<? extends Resource[]> getObjectType() {
        return Resource[].class;
    }

    public boolean isSingleton() {
        return true;
    }
}

