<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
                      "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<%@ page language="java" contentType="text/html; charset=ISO-8859-1" pageEncoding="ISO-8859-1"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ page import="com.jispot.web.Constants"%>
<%
  String message = (String) request.getAttribute("message");
  final String path = request.getContextPath();
  final String pathStatic = path + "/static";
  final String pathCSS = pathStatic + "/css";
  final String pathJS = pathStatic + "/js";
  final String pathIMG = pathStatic + "/img";
%>

<head>
  <title><fmt:message key="header.html.title"/></title>
  <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
  <link rel="shortcut icon" href="<%=path%>/favico.ico" type="image/favicon-icon" />
  <link type="text/css" rel="stylesheet" href="<%=pathCSS%>/layout.css" />
  <link type="text/css" rel="stylesheet" href="<%=pathCSS%>/base.css" />
  <link type="text/css" rel="stylesheet" href="<%=pathCSS%>/main.css" />
  <link type="text/css" rel="stylesheet" href="<%=pathCSS%>/menu.css" />
  <link type="text/css" rel="Stylesheet" href="<%=pathCSS%>/ui-lightness/jquery-ui-1.7.1.custom.css" />   
  <link type="text/css" rel="stylesheet" href="<%=pathCSS%>/jquery.loadmask.css"  />
  <script type="text/javascript" src="<%=pathJS%>/jispot/jispot.ajax.js"></script>
  <script type="text/javascript" src="<%=pathJS%>/jquery-1.4.min.js"></script>
  <script type="text/javascript" src="<%=pathJS%>/jquery-ui-1.7.2.custom.min.js"></script>
  <script type="text/javascript" src="<%=pathJS%>/jquery.tools.min.js"></script>
  <script type="text/javascript" src="<%=pathJS%>/jquery.form.js"></script>
  <script type="text/javascript" src="<%=pathJS%>/jquery.pngFix.pack.js"></script> 
  <script type="text/javascript" src="<%=pathJS%>/jquery.loadmask.js"></script>
  <script type="text/javascript">
  $(document).ready(function(){ 
      $(document).pngFix(); 
  }); 
  function internalerror(){ 
    alert("An error occured, our support team has been warned.\n"+
          "This page must be reloaded now!");
    window.location.replace("<%=path%>/");
  }
  </script>
</head>

<body id="body">
<div id="doc4" class="yui-t5">
    <div id="header">
      <div id="logo"><img src="<%=pathIMG%>/logo.png" alt="JI-SPot Logo" width="100px"/></div>
    </div> <%-- END header --%>

    <div id="bd">
        <div id="yui-main">
          <div class="yui-b">

<%-- INSERTION DE LA NAVIGATION PAR ONGLET --%>
<ul id="flowtabs">
	<li><a id="t1" href="#home"><fmt:message key="menu.home"/></a></li>
	<li><a id="t2" href="#features"><fmt:message key="menu.features"/></a></li>
	<li><a id="t3" href="#tour"><fmt:message key="menu.tour"/></a></li>
	<li><a id="t4" href="#search"><fmt:message key="menu.search"/></a></li>
</ul>

<!-- panes -->
<div id="flowpanes"><%-- remove the space between tabs and panes --%>
  <br clear="all" />
  <jsp:include page="home.jsp" flush="true" /> 
  <jsp:include page="features.jsp" flush="true" /> 
  <jsp:include page="tour.jsp" flush="true" /> 
  <jsp:include page="search.jsp" flush="true" /> 
</div>
<%-- activate tabs with JavaScript --%>
<script>
$(function() {
  $("#flowtabs").tabs("#flowpanes > div").history();
});
</script>	

<%-- FIN DE LA NAVIGATION PAR ONGLET --%>

          </div>
        </div>
        <div class="yui-b">
          <jsp:include page="login.jsp" flush="true" />
          <br />
          <jsp:include page="subscribe.jsp" flush="true" />
        </div>
    </div>
    <div id="footer">
      <a href="<%=path%>/index.html" rel="nofollow"><fmt:message key="footer.home"/></a>&nbsp;|&nbsp;
      <a href="<%=path%>/about.html" rel="nofollow"><fmt:message key="footer.about"/></a>&nbsp;|&nbsp;
      <a href="<%=path%>/faq.html" rel="nofollow"><fmt:message key="footer.faq"/></a>&nbsp;|&nbsp;
      <a href="<%=path%>/downloads.html" rel="nofollow"><fmt:message key="footer.downloads"/></a>&nbsp;|&nbsp;
      <a href="<%=path%>/api.html" rel="nofollow"><fmt:message key="footer.developer"/></a>&nbsp;|&nbsp;
      <a href="<%=path%>/help.html" rel="nofollow"><fmt:message key="footer.help"/></a>&nbsp;|&nbsp;
      <a href="<%=path%>/privacy.html" rel="nofollow"><fmt:message key="footer.privacy"/></a>&nbsp;|&nbsp;
      <a href="<%=path%>/terms_of_service.html" rel="nofollow"><fmt:message key="footer.terms"/></a>
      <br />
      <fmt:message key="footer.copyright"/>
    </div>
</div>

</body>
</html>

