/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Range;
import com.google.appengine.repackaged.com.google.common.base.Ranges;
import java.io.Serializable;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
@GwtCompatible(serializable=true)
final class RangeClosed<V extends Comparable<? super V>>
implements Range<V>,
Serializable {
    private final V min;
    private final V max;
    private static final long serialVersionUID = 0L;

    RangeClosed(V min, V max) {
        if (min == null) {
            throw new NullPointerException("Parameter 'min' is null.");
        }
        if (max == null) {
            throw new NullPointerException("Parameter 'max' is null.");
        }
        if (min.compareTo(max) > 0) {
            throw new IllegalArgumentException("Parameter 'min' cannot be greater than Parameter 'max'.");
        }
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean contains(V value) {
        return value != null && this.min.compareTo(value) < 1 && this.max.compareTo(value) > -1;
    }

    @Override
    public Range<V> enclose(V value) {
        if (value == null) {
            return this;
        }
        if (this.isEmpty()) {
            return new RangeClosed<V>(value, value);
        }
        return this.min.compareTo(value) > 0 ? new RangeClosed(value, this.max) : (this.max.compareTo(value) < 0 ? new RangeClosed<V>(this.min, value) : this);
    }

    @Override
    public Range<V> enclosure(Range<V> range) {
        if (range.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return range;
        }
        V oMin = range.min();
        V oMax = range.max();
        return new RangeClosed<V>(oMin.compareTo(this.min) < 0 ? oMin : this.min, oMax.compareTo(this.max) > 0 ? oMax : this.max);
    }

    public String toString() {
        return "[Range:" + this.min + ", " + this.max + "]";
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o instanceof Range) {
            Range c = (Range)o;
            try {
                if (c.isEmpty()) {
                    return false;
                }
                return c.min().equals(this.min) && c.max().equals(this.max);
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.min.hashCode() * 555557 + this.max.hashCode();
    }

    @Override
    public Range<V> intersection(Range<V> range) {
        if (!this.intersects(range)) {
            return Ranges.emptyRange();
        }
        V oMin = range.min();
        V oMax = range.max();
        return new RangeClosed<V>(oMin.compareTo(this.min) > 0 ? oMin : this.min, oMax.compareTo(this.max) < 0 ? oMax : this.max);
    }

    @Override
    public boolean intersects(Range<V> range) {
        if (range.isEmpty()) {
            return false;
        }
        return this.max.compareTo(range.min()) > -1 && this.min.compareTo(range.max()) < 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public V max() {
        return this.max;
    }

    @Override
    public V min() {
        return this.min;
    }
}

