/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.convert.support;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConverterNotFoundException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConversionUtils;
import org.springframework.core.convert.support.GenericConversionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ArrayToCollectionConverter
implements ConditionalGenericConverter {
    private final GenericConversionService conversionService;

    public ArrayToCollectionConverter(GenericConversionService conversionService) {
        this.conversionService = conversionService;
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Object[].class, Collection.class));
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService.canConvert(sourceType.getElementTypeDescriptor(), targetType.getElementTypeDescriptor());
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return this.conversionService.convertNullSource(sourceType, targetType);
        }
        int length = Array.getLength(source);
        Collection collection = CollectionFactory.createCollection(targetType.getType(), length);
        TypeDescriptor sourceElementType = sourceType.getElementTypeDescriptor();
        TypeDescriptor targetElementType = targetType.getElementTypeDescriptor();
        if (targetElementType == TypeDescriptor.NULL || sourceElementType.isAssignableTo(targetElementType)) {
            int i = 0;
            while (i < length) {
                collection.add(Array.get(source, i));
                ++i;
            }
        } else {
            GenericConverter converter = this.conversionService.getConverter(sourceElementType, targetElementType);
            if (converter == null) {
                throw new ConverterNotFoundException(sourceElementType, targetElementType);
            }
            int i = 0;
            while (i < length) {
                Object sourceElement = Array.get(source, i);
                Object targetElement = ConversionUtils.invokeConverter(converter, sourceElement, sourceElementType, targetElementType);
                collection.add(targetElement);
                ++i;
            }
        }
        return collection;
    }
}

