/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.valang.javascript;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AndPredicate;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.collections.functors.OrPredicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.ReflectiveVisitorHelper;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.JavaScriptUtils;
import org.springmodules.validation.valang.functions.AbstractFunction;
import org.springmodules.validation.valang.functions.AbstractMathFunction;
import org.springmodules.validation.valang.functions.AddFunction;
import org.springmodules.validation.valang.functions.BeanPropertyFunction;
import org.springmodules.validation.valang.functions.DateLiteralFunction;
import org.springmodules.validation.valang.functions.DivideFunction;
import org.springmodules.validation.valang.functions.Function;
import org.springmodules.validation.valang.functions.LengthOfFunction;
import org.springmodules.validation.valang.functions.LiteralFunction;
import org.springmodules.validation.valang.functions.LowerCaseFunction;
import org.springmodules.validation.valang.functions.MapEntryFunction;
import org.springmodules.validation.valang.functions.ModuloFunction;
import org.springmodules.validation.valang.functions.MultiplyFunction;
import org.springmodules.validation.valang.functions.NotFunction;
import org.springmodules.validation.valang.functions.SubtractFunction;
import org.springmodules.validation.valang.functions.TargetBeanFunction;
import org.springmodules.validation.valang.functions.UpperCaseFunction;
import org.springmodules.validation.valang.predicates.BasicValidationRule;
import org.springmodules.validation.valang.predicates.GenericTestPredicate;
import org.springmodules.validation.valang.predicates.Operator;

public class ValangJavaScriptTranslator {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springmodules$validation$valang$javascript$ValangJavaScriptTranslator == null ? (class$org$springmodules$validation$valang$javascript$ValangJavaScriptTranslator = ValangJavaScriptTranslator.class$("org.springmodules.validation.valang.javascript.ValangJavaScriptTranslator")) : class$org$springmodules$validation$valang$javascript$ValangJavaScriptTranslator));
    private static final ReflectiveVisitorHelper reflectiveVisitorHelper = new ReflectiveVisitorHelper();
    private Writer writer;
    static /* synthetic */ Class class$org$springmodules$validation$valang$javascript$ValangJavaScriptTranslator;

    public static Reader getCodebaseReader() {
        return new InputStreamReader((class$org$springmodules$validation$valang$javascript$ValangJavaScriptTranslator == null ? (class$org$springmodules$validation$valang$javascript$ValangJavaScriptTranslator = ValangJavaScriptTranslator.class$("org.springmodules.validation.valang.javascript.ValangJavaScriptTranslator")) : class$org$springmodules$validation$valang$javascript$ValangJavaScriptTranslator).getResourceAsStream("valang_codebase.js"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeJavaScriptValangValidator(Writer writer, String name, boolean installSelfWithForm, Collection rules, MessageSourceAccessor messageSource) throws IOException {
        try {
            this.setWriter(writer);
            this.append("new ValangValidator(");
            this.appendJsString(name);
            this.append(',');
            this.append(Boolean.toString(installSelfWithForm));
            this.append(',');
            this.appendArrayValidators(rules, messageSource);
            this.append(')');
        }
        finally {
            this.clearWriter();
        }
    }

    protected void setWriter(Writer writer) {
        Assert.state((this.writer == null ? 1 : 0) != 0, (String)"Attempted to set writer when one already set - is this class being used is multiple threads?");
        this.writer = writer;
    }

    protected void clearWriter() {
        this.writer = null;
    }

    protected void append(String string) throws IOException {
        this.writer.write(string);
    }

    protected void appendJsString(String string) throws IOException {
        this.writer.write(39);
        if (string == null) {
            this.writer.write("null");
        } else {
            this.writer.write(JavaScriptUtils.javaScriptEscape((String)string));
        }
        this.writer.write(39);
    }

    protected void append(char c) throws IOException {
        this.writer.write(c);
    }

    private void append(int i) throws IOException {
        this.writer.write(Integer.toString(i));
    }

    protected void appendArrayValidators(Collection rules, MessageSourceAccessor messageSource) throws IOException {
        this.append("new Array(");
        Iterator i = rules.iterator();
        while (i.hasNext()) {
            this.appendValidatorRule((BasicValidationRule)i.next(), messageSource);
            if (!i.hasNext()) continue;
            this.append(',');
        }
        this.append(')');
    }

    protected void appendValidatorRule(BasicValidationRule rule, MessageSourceAccessor messageSource) throws IOException {
        this.append("new ValangValidator.Rule('");
        this.append(rule.getField());
        this.append("','not implemented',");
        this.appendJsString(this.getErrorMessage(rule, messageSource));
        this.append(',');
        this.appendValidationFunction(rule.getPredicate());
        this.append(')');
    }

    protected String getErrorMessage(BasicValidationRule rule, MessageSourceAccessor messageSource) {
        if (StringUtils.hasLength((String)rule.getErrorKey())) {
            if (rule.getErrorArgs() != null && !rule.getErrorArgs().isEmpty()) {
                logger.warn((Object)"Translating error message with arguments is not implemented; using default message");
                return rule.getErrorMessage();
            }
            return messageSource.getMessage(rule.getErrorKey(), rule.getErrorMessage());
        }
        return rule.getErrorMessage();
    }

    protected void appendValidationFunction(Predicate p) throws IOException {
        this.append("function() {return ");
        this.doVisit(p);
        this.append('}');
    }

    protected void doVisit(Object value) throws IOException {
        reflectiveVisitorHelper.invokeVisit((Object)this, value);
    }

    void visitNull() throws IOException {
        this.append("null");
    }

    void visit(Function f) throws IOException {
        if (logger.isWarnEnabled()) {
            logger.warn((Object)("Encountered unsupported custom function '" + f.getClass().getName() + "'"));
        }
        this.append("this._throwError('don\\'t know how to handle custom function \\'");
        this.append(this.getNameForCustomFunction(f));
        this.append("\\'')");
    }

    void visit(AbstractFunction f) throws IOException {
        Function[] arguments = f.getArguments();
        this.append(this.getNameForCustomFunction(f));
        this.append('(');
        for (int i = 0; i < arguments.length; ++i) {
            this.doVisit(arguments[i]);
            if (i >= arguments.length - 1) continue;
            this.append(',');
        }
        this.append(')');
    }

    protected String getNameForCustomFunction(Function f) {
        return "this." + ClassUtils.getShortName(f.getClass());
    }

    void visit(NotPredicate p) throws IOException {
        Assert.isTrue((p.getPredicates().length == 1 ? 1 : 0) != 0);
        this.append("! (");
        this.doVisit(p.getPredicates()[0]);
        this.append(')');
    }

    void visit(AndPredicate p) throws IOException {
        String op = ") && ";
        for (int i = 0; i < p.getPredicates().length; ++i) {
            Predicate innerP = p.getPredicates()[i];
            this.append('(');
            this.doVisit(innerP);
            if (i < p.getPredicates().length - 1) {
                this.append(op);
                continue;
            }
            this.append(')');
        }
    }

    void visit(OrPredicate p) throws IOException {
        String op = ") || ";
        for (int i = 0; i < p.getPredicates().length; ++i) {
            Predicate innerP = p.getPredicates()[i];
            this.append('(');
            this.doVisit(innerP);
            if (i < p.getPredicates().length - 1) {
                this.append(op);
                continue;
            }
            this.append(')');
        }
    }

    void visit(GenericTestPredicate p) throws IOException {
        this.append(this.operatorToFunctionName(p.getOperator()));
        this.append("((");
        this.doVisit(p.getLeftFunction());
        this.append("), (");
        this.doVisit(p.getRightFunction());
        this.append("))");
    }

    protected String operatorToFunctionName(Operator operator) {
        if (operator instanceof Operator.EqualsOperator) {
            return "this.equals";
        }
        if (operator instanceof Operator.NotEqualsOperator) {
            return "! this.equals";
        }
        if (operator instanceof Operator.LessThanOperator) {
            return "this.lessThan";
        }
        if (operator instanceof Operator.LessThanOrEqualOperator) {
            return "this.lessThanOrEquals";
        }
        if (operator instanceof Operator.MoreThanOperator) {
            return "this.moreThan";
        }
        if (operator instanceof Operator.MoreThanOrEqualOperator) {
            return "this.moreThanOrEquals";
        }
        if (operator instanceof Operator.InOperator) {
            return "this.inFunc";
        }
        if (operator instanceof Operator.NotInOperator) {
            return "! this.inFunc";
        }
        if (operator instanceof Operator.BetweenOperator) {
            return "this.between";
        }
        if (operator instanceof Operator.NotBetweenOperator) {
            return "! this.between";
        }
        if (operator instanceof Operator.NullOperator) {
            return "this.nullFunc";
        }
        if (operator instanceof Operator.NotNullOperator) {
            return "! this.nullFunc";
        }
        if (operator instanceof Operator.HasTextOperator) {
            return "this.hasText";
        }
        if (operator instanceof Operator.HasNoTextOperator) {
            return "! this.hasText";
        }
        if (operator instanceof Operator.HasLengthOperator) {
            return "this.hasLength";
        }
        if (operator instanceof Operator.HasNoLengthOperator) {
            return "! this.hasLength";
        }
        if (operator instanceof Operator.IsBlankOperator) {
            return "this.isBlank";
        }
        if (operator instanceof Operator.IsNotBlankOperator) {
            return "! this.isBlank";
        }
        if (operator instanceof Operator.IsWordOperator) {
            return "this.isWord";
        }
        if (operator instanceof Operator.IsNotWordOperator) {
            return "! this.isWord";
        }
        if (operator instanceof Operator.IsUpperCaseOperator) {
            return "this.isUpper";
        }
        if (operator instanceof Operator.IsNotUpperCaseOperator) {
            return "! this.isUpper";
        }
        if (operator instanceof Operator.IsLowerCaseOperator) {
            return "this.isLower";
        }
        if (operator instanceof Operator.IsNotLowerCaseOperator) {
            return "! this.isLower";
        }
        throw new UnsupportedOperationException("Unexpected operator type '" + operator.getClass().getName() + "'");
    }

    void visit(TargetBeanFunction f) throws IOException {
        this.append("this.getTargetBean()");
    }

    void visit(BeanPropertyFunction f) throws IOException {
        this.append("this.getPropertyValue(");
        this.appendJsString(f.getField());
        this.append(')');
    }

    void visit(MapEntryFunction f) throws IOException {
        this.append("(");
        this.doVisit(f.getMapFunction());
        this.append("[");
        this.doVisit(f.getKeyFunction());
        this.append("])");
    }

    void visit(LiteralFunction f) throws IOException {
        Object literal = f.getResult(null);
        if (literal instanceof String) {
            this.appendJsString((String)literal);
        } else if (literal instanceof Number) {
            this.append(literal.toString());
        } else if (literal instanceof Boolean) {
            this.append(literal.toString());
        } else if (literal instanceof Function[]) {
            Object[] functions = (Function[])literal;
            this.appeandLiteralArray(functions);
        } else if (literal instanceof Collection) {
            this.appeandLiteralArray(((Collection)literal).toArray());
        } else {
            throw new UnsupportedOperationException("Unexpected literal type '" + literal.getClass() + "'");
        }
    }

    void appeandLiteralArray(Object[] functions) throws IOException {
        this.append("new Array(");
        for (int i = 0; i < functions.length; ++i) {
            this.doVisit(functions[i]);
            if (i >= functions.length - 1) continue;
            this.append(",");
        }
        this.append(')');
    }

    void visit(DateLiteralFunction f) throws IOException {
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)f.getResult(null));
        this.append("new Date(");
        this.append(cal.get(1));
        this.append(", ");
        this.append(cal.get(2));
        this.append(", ");
        this.append(cal.get(5));
        this.append(", ");
        this.append(cal.get(11));
        this.append(", ");
        this.append(cal.get(12));
        this.append(", ");
        this.append(cal.get(13));
        this.append(", ");
        this.append(cal.get(14));
        this.append(')');
    }

    void visit(LengthOfFunction f) throws IOException {
        this.append("this.lengthOf(");
        this.doVisit(f.getArguments()[0]);
        this.append(')');
    }

    void visit(NotFunction f) throws IOException {
        this.append("! ");
        this.doVisit(f.getArguments()[0]);
    }

    void visit(UpperCaseFunction f) throws IOException {
        this.append("this.upperCase(");
        this.doVisit(f.getArguments()[0]);
        this.append(')');
    }

    void visit(LowerCaseFunction f) throws IOException {
        this.append("this.lowerCase(");
        this.doVisit(f.getArguments()[0]);
        this.append(')');
    }

    void visit(AbstractMathFunction f) throws IOException {
        this.append(this.mathToFunctionName(f));
        this.append("((");
        this.doVisit(f.getLeftFunction());
        this.append("),(");
        this.doVisit(f.getRightFunction());
        this.append("))");
    }

    protected String mathToFunctionName(AbstractMathFunction f) {
        if (f instanceof AddFunction) {
            return "this.add";
        }
        if (f instanceof DivideFunction) {
            return "this.divide";
        }
        if (f instanceof ModuloFunction) {
            return "this.modulo";
        }
        if (f instanceof MultiplyFunction) {
            return "this.multiply";
        }
        if (f instanceof SubtractFunction) {
            return "this.subtract";
        }
        throw new UnsupportedOperationException("Unexpected math function type '" + f.getClass().getName() + "'");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

