/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.management.runtime;

import org.datanucleus.management.runtime.TransactionRuntimeMBean;
import org.datanucleus.util.MathUtils;

public class TransactionRuntime
implements TransactionRuntimeMBean {
    long transactionTotalCount;
    long transactionCommittedTotalCount;
    long transactionRolledBackTotalCount;
    long transactionActiveTotalCount;
    MathUtils.SMA executionTimeAverage = new MathUtils.SMA(50);
    long executionTotalTime = 0L;
    long executionTimeHigh = -1L;
    long executionTimeLow = -1L;

    public long getTransactionExecutionTimeAverage() {
        return (long)this.executionTimeAverage.currentAverage();
    }

    public long getTransactionExecutionTimeLow() {
        return this.executionTimeLow;
    }

    public long getTransactionExecutionTimeHigh() {
        return this.executionTimeHigh;
    }

    public long getTransactionExecutionTotalTime() {
        return this.executionTotalTime;
    }

    public long getTransactionTotalCount() {
        return this.transactionTotalCount;
    }

    public long getTransactionActiveTotalCount() {
        return this.transactionActiveTotalCount;
    }

    public long getTransactionCommittedTotalCount() {
        return this.transactionCommittedTotalCount;
    }

    public long getTransactionRolledBackTotalCount() {
        return this.transactionRolledBackTotalCount;
    }

    public void transactionCommitted(long executionTime) {
        ++this.transactionCommittedTotalCount;
        --this.transactionActiveTotalCount;
        this.executionTimeAverage.compute(executionTime);
        this.executionTimeLow = Math.min(this.executionTimeLow == -1L ? executionTime : this.executionTimeLow, executionTime);
        this.executionTimeHigh = Math.max(this.executionTimeHigh, executionTime);
        this.executionTotalTime += executionTime;
    }

    public void transactionRolledBack(long executionTime) {
        ++this.transactionRolledBackTotalCount;
        --this.transactionActiveTotalCount;
        this.executionTimeAverage.compute(executionTime);
        this.executionTimeLow = Math.min(this.executionTimeLow == -1L ? executionTime : this.executionTimeLow, executionTime);
        this.executionTimeHigh = Math.max(this.executionTimeHigh, executionTime);
        this.executionTotalTime += executionTime;
    }

    public void transactionStarted() {
        ++this.transactionTotalCount;
        ++this.transactionActiveTotalCount;
    }
}

