/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.Key;
import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ManagedConnection;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.appengine.DatastoreFieldManager;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastoreTable;
import org.datanucleus.store.appengine.EmulatedXAResource;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;

class KeyRegistry {
    private final Map<Object, Key> parentKeyMap = new IdentityHashMap<Object, Key>();
    private final Set<Key> modifiedParentSet = new HashSet<Key>();

    KeyRegistry() {
    }

    void registerKey(StateManager stateMgr, DatastoreFieldManager fieldMgr) {
        DatastoreTable dt = fieldMgr.getDatastoreTable();
        SingleValueFieldManager sfv = new SingleValueFieldManager();
        Key key = fieldMgr.getEntity().getKey();
        AbstractClassMetaData acmd = stateMgr.getClassMetaData();
        for (AbstractMemberMetaData dependent : dt.getSameEntityGroupMemberMetaData()) {
            if (!dependent.getAbstractClassMetaData().isSameOrAncestorOf(acmd)) continue;
            stateMgr.provideFields(new int[]{dependent.getAbsoluteFieldNumber()}, (FieldManager)sfv);
            List<Object> childValue = sfv.fetchObjectField(dependent.getAbsoluteFieldNumber());
            if (childValue == null) continue;
            if (childValue instanceof Object[]) {
                childValue = Arrays.asList((Object[])childValue);
            }
            if (childValue instanceof Iterable) {
                String expectedType = this.getExpectedChildType(dependent);
                for (Object element : (Iterable)childValue) {
                    this.addToParentKeyMap(element, key, stateMgr, expectedType, true);
                }
                continue;
            }
            boolean checkForPolymorphism = !dt.isParentKeyProvider(dependent);
            this.addToParentKeyMap(childValue, key, stateMgr, this.getExpectedChildType(dependent), checkForPolymorphism);
        }
    }

    private String getExpectedChildType(AbstractMemberMetaData dependent) {
        if (dependent.getCollection() != null) {
            CollectionMetaData cmd = dependent.getCollection();
            return cmd.getElementType();
        }
        if (dependent.getArray() != null) {
            ArrayMetaData amd = dependent.getArray();
            return amd.getElementType();
        }
        return dependent.getTypeName();
    }

    void registerKey(Object childValue, Key key, StateManager stateMgr, String expectedType) {
        this.addToParentKeyMap(childValue, key, stateMgr, expectedType, false);
    }

    Key getRegisteredKey(Object object) {
        return this.parentKeyMap.get(object);
    }

    void clear() {
        this.parentKeyMap.clear();
    }

    private void addToParentKeyMap(Object childValue, Key key, StateManager stateMgr, String expectedType, boolean checkForPolymorphism) {
        AbstractClassMetaData acmd;
        if (checkForPolymorphism && childValue != null && !childValue.getClass().getName().equals(expectedType) && !DatastoreManager.isNewOrSuperclassTableInheritanceStrategy(acmd = stateMgr.getMetaDataManager().getMetaDataForClass(childValue.getClass(), stateMgr.getObjectManager().getClassLoaderResolver()))) {
            boolean isJPA = ((DatastoreManager)stateMgr.getStoreManager()).isJPA();
            throw new UnsupportedOperationException("Received a child of type " + childValue.getClass().getName() + " for a field of type " + expectedType + ". Unfortunately polymorphism in relationships is only supported for the " + (isJPA ? "SINGLE_TABLE" : "superclass-table") + " inheritance mapping strategy.");
        }
        this.parentKeyMap.put(childValue, key);
    }

    static KeyRegistry getKeyRegistry(ObjectManager om) {
        StoreManager storeManager = om.getStoreManager();
        ManagedConnection mconn = storeManager.getConnection(om);
        return ((EmulatedXAResource)mconn.getXAResource()).getKeyRegistry();
    }

    void registerModifiedParent(Key key) {
        this.modifiedParentSet.add(key);
    }

    void clearModifiedParent(Key key) {
        this.modifiedParentSet.remove(key);
    }

    boolean parentNeedsUpdate(Key key) {
        return this.modifiedParentSet.contains(key);
    }
}

