/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.datanucleus.ObjectManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.properties.PersistencePropertyValidator;
import org.datanucleus.properties.PropertyTypeInvalidException;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceConfiguration {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManager.class.getClassLoader());
    private Map<String, Object> properties = new HashMap<String, Object>();
    private Map<String, PropertyMapping> propertyMappings = new HashMap<String, PropertyMapping>();
    private transient Calendar dateTimezoneCalendar = null;
    private boolean jca = false;
    protected transient boolean configurable = true;

    public Map<String, Object> getOptions() {
        return this.properties;
    }

    public Set getSupportedOptions() {
        return this.propertyMappings.keySet();
    }

    public void setDefaultProperties(PluginManager pluginMgr) {
        ConfigurationElement[] propElements = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.persistence_properties", null, null);
        if (propElements != null) {
            for (int i = 0; i < propElements.length; ++i) {
                String name = propElements[i].getAttribute("name");
                String intName = propElements[i].getAttribute("internal-name");
                String value = propElements[i].getAttribute("value");
                this.propertyMappings.put(name, new PropertyMapping(name, intName, value, propElements[i].getAttribute("validator")));
                String systemValue = System.getProperty(name);
                if (systemValue != null) {
                    if (intName != null) {
                        this.properties.put(intName, systemValue);
                        continue;
                    }
                    this.properties.put(name, systemValue);
                    continue;
                }
                if (this.properties.containsKey(name) || value == null) continue;
                if (intName != null) {
                    this.properties.put(intName, value);
                    continue;
                }
                this.properties.put(name, value);
            }
        }
    }

    public boolean hasProperty(String name) {
        return this.properties.get(name) != null;
    }

    public long getLongProperty(String name) {
        Object obj = this.properties.get(name);
        if (obj != null) {
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            if (obj instanceof String) {
                Long longVal = new Long((String)obj);
                this.properties.put(name, longVal);
                return longVal;
            }
        } else {
            return 0L;
        }
        throw new PropertyTypeInvalidException(name, "long");
    }

    public int getIntProperty(String name) {
        Object obj = this.properties.get(name);
        if (obj != null) {
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            if (obj instanceof String) {
                Integer intVal = new Integer((String)obj);
                this.properties.put(name, intVal);
                return intVal;
            }
        } else {
            return 0;
        }
        throw new PropertyTypeInvalidException(name, "int");
    }

    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(String name, boolean resultIfNotSet) {
        Object obj = this.properties.get(name);
        if (obj != null) {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj instanceof String) {
                Boolean boolVal = new Boolean((String)obj);
                this.properties.put(name, boolVal);
                return boolVal;
            }
        } else {
            return resultIfNotSet;
        }
        throw new PropertyTypeInvalidException(name, "boolean");
    }

    public Boolean getBooleanObjectProperty(String name) {
        Object obj = this.properties.get(name);
        if (obj != null) {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj instanceof String) {
                Boolean boolVal = new Boolean((String)obj);
                this.properties.put(name, boolVal);
                return boolVal;
            }
        } else {
            return null;
        }
        throw new PropertyTypeInvalidException(name, "Boolean");
    }

    public String getStringProperty(String name) {
        Object obj = this.properties.get(name);
        if (obj != null) {
            if (obj instanceof String) {
                return (String)obj;
            }
        } else {
            return null;
        }
        throw new PropertyTypeInvalidException(name, "String");
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public synchronized boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PersistenceConfiguration)) {
            return false;
        }
        PersistenceConfiguration config = (PersistenceConfiguration)obj;
        return this.equalsVariable(this.properties, config.properties);
    }

    private boolean equalsVariable(Object var1, Object var2) {
        return !(var1 == null ? var2 != null : !var1.equals(var2));
    }

    public Calendar getCalendarForDateTimezone() {
        if (this.dateTimezoneCalendar == null) {
            String serverTimeZoneID = this.getStringProperty("datanucleus.ServerTimeZoneID");
            TimeZone tz = serverTimeZoneID != null ? TimeZone.getTimeZone(serverTimeZoneID) : TimeZone.getDefault();
            this.dateTimezoneCalendar = new GregorianCalendar(tz);
        }
        return (Calendar)this.dateTimezoneCalendar.clone();
    }

    public void setPrimaryClassLoader(ClassLoader loader) {
        this.setProperty("datanucleus.primaryClassLoader", loader);
    }

    public ClassLoader getPrimaryClassLoader() {
        return (ClassLoader)this.getProperty("datanucleus.primaryClassLoader");
    }

    public synchronized void setJCAMode(boolean jca) {
        this.assertConfigurable();
        this.jca = jca;
    }

    public boolean isJcaMode() {
        return this.jca;
    }

    public synchronized void setPropertiesFile(String value) {
        this.assertConfigurable();
        if (value == null) {
            return;
        }
        Properties props = new Properties();
        File file = new File(value);
        if (file.exists()) {
            this.properties.put("datanucleus.propertiesFile", value);
            try {
                FileInputStream is = new FileInputStream(file);
                props.load(is);
                ((InputStream)is).close();
            }
            catch (FileNotFoundException e) {
                this.properties.remove("datanucleus.propertiesFile");
                throw new NucleusUserException(LOCALISER.msg("008014", (Object)value), e).setFatal();
            }
            catch (IOException e) {
                this.properties.remove("datanucleus.propertiesFile");
                throw new NucleusUserException(LOCALISER.msg("008014", (Object)value), e).setFatal();
            }
        }
        try {
            InputStream is = PersistenceConfiguration.class.getClassLoader().getResourceAsStream(value);
            props.load(is);
            is.close();
            this.properties.put("datanucleus.propertiesFile", value);
        }
        catch (Exception e) {
            throw new NucleusUserException(LOCALISER.msg("008014", (Object)value), e).setFatal();
        }
        this.setOptions(props);
    }

    public void setOptions(Map props) {
        Set keys = props.keySet();
        for (Object keyObj : keys) {
            if (!(keyObj instanceof String)) continue;
            String key = (String)keyObj;
            Object valueObj = props.get(keyObj);
            this.setProperty(key, valueObj);
        }
    }

    public void setProperty(String name, Object value) {
        if (name != null) {
            String propertyName = name.trim();
            PropertyMapping mapping = this.propertyMappings.get(propertyName);
            if (mapping != null) {
                if (mapping.validatorName != null) {
                    PersistencePropertyValidator validator = null;
                    try {
                        Class<?> validatorCls = Class.forName(mapping.validatorName);
                        validator = (PersistencePropertyValidator)validatorCls.newInstance();
                    }
                    catch (Exception e) {
                        NucleusLogger.JDO.warn("Error creating validator of type " + mapping.validatorName, e);
                    }
                    if (validator != null) {
                        boolean validated;
                        boolean bl = validated = mapping.internalName != null ? validator.validate(mapping.internalName, value) : validator.validate(propertyName, value);
                        if (!validated) {
                            throw new IllegalArgumentException(LOCALISER.msg("008012", (Object)propertyName, value));
                        }
                    }
                }
                if (mapping.internalName != null) {
                    this.properties.put(mapping.internalName, value);
                } else {
                    this.properties.put(mapping.name, value);
                }
                if (propertyName.equals("datanucleus.propertiesFile")) {
                    this.setPropertiesFile((String)value);
                } else if (propertyName.equals("datanucleus.messageCodesIncluded")) {
                    boolean included = this.getBooleanProperty("datanucleus.messageCodesIncluded");
                    Localiser.setDisplayCodesInMessages(included);
                }
            } else {
                this.properties.put(propertyName, value);
                if (this.propertyMappings.size() > 0) {
                    NucleusLogger.PERSISTENCE.info(LOCALISER.msg("008015", (Object)propertyName));
                }
            }
        }
    }

    protected void assertConfigurable() {
        if (!this.configurable) {
            throw new NucleusUserException(LOCALISER.msg("008016"));
        }
    }

    class PropertyMapping {
        String name;
        String internalName;
        String value;
        String validatorName;

        public PropertyMapping(String name, String intName, String val, String validator) {
            this.name = name;
            this.internalName = intName;
            this.value = val;
            this.validatorName = validator;
        }
    }
}

