package com.jispot.common.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

import com.jispot.common.JISpotDefaultProperties;

/**
 * This class is used to centralized all the calls to the DruideGUI I18n system.
 */
public class I18nError {

	private I18nError() {
	}
	private static final String BASE_NAME = "jispot-errors";
	
	private static Map<Locale, ResourceBundle> bundles = new HashMap<Locale, ResourceBundle>();

	public static ResourceBundle get() {
		return get(JISpotDefaultProperties.getLang() );
	}
	public static ResourceBundle get(String lang) {
		return get(new Locale( lang ) );
	}
	public static ResourceBundle get(Locale locale) {
		ResourceBundle b = bundles.get(locale);
		if (b == null) {
			b =ResourceBundle.getBundle(BASE_NAME, locale);
		}
		return b;
	}
	
}
