/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.loader.xml;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ClassUtils;
import org.springmodules.validation.bean.conf.BeanValidationConfiguration;
import org.springmodules.validation.bean.conf.loader.BeanValidationConfigurationLoader;

public abstract class AbstractResourceBasedBeanValidationConfigurationLoader
implements BeanValidationConfigurationLoader,
InitializingBean {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springmodules$validation$bean$conf$loader$xml$AbstractResourceBasedBeanValidationConfigurationLoader == null ? (class$org$springmodules$validation$bean$conf$loader$xml$AbstractResourceBasedBeanValidationConfigurationLoader = AbstractResourceBasedBeanValidationConfigurationLoader.class$("org.springmodules.validation.bean.conf.loader.xml.AbstractResourceBasedBeanValidationConfigurationLoader")) : class$org$springmodules$validation$bean$conf$loader$xml$AbstractResourceBasedBeanValidationConfigurationLoader));
    private static final String DEFAULT_RESOURCE_EXTENTION = ".vld.xml";
    private Map configurationByClass;
    private Resource[] resources;
    static /* synthetic */ Class class$org$springmodules$validation$bean$conf$loader$xml$AbstractResourceBasedBeanValidationConfigurationLoader;

    public AbstractResourceBasedBeanValidationConfigurationLoader() {
        this(new Resource[0]);
    }

    public AbstractResourceBasedBeanValidationConfigurationLoader(Resource[] resources) {
        this.resources = resources;
        this.configurationByClass = new HashMap();
    }

    public final BeanValidationConfiguration loadConfiguration(Class clazz) {
        BeanValidationConfiguration configuration = (BeanValidationConfiguration)this.configurationByClass.get(clazz);
        if (configuration != null) {
            return configuration;
        }
        return this.loadDefaultConfiguration(clazz);
    }

    public final boolean supports(Class clazz) {
        return this.configurationByClass.get(clazz) != null;
    }

    public void afterPropertiesSet() throws Exception {
        for (int i = 0; i < this.resources.length; ++i) {
            Map configurations = this.loadConfigurations(this.resources[i]);
            this.configurationByClass.putAll(configurations);
        }
    }

    protected abstract Map loadConfigurations(Resource var1);

    public Resource[] getResources() {
        return this.resources;
    }

    public void setResources(Resource[] resources) {
        this.resources = resources;
    }

    public Resource getResource() {
        return this.resources[0] != null ? this.resources[0] : null;
    }

    public void setResource(Resource resource) {
        this.setResources(new Resource[]{resource});
    }

    protected BeanValidationConfiguration loadDefaultConfiguration(Class clazz) {
        String fileName = this.createDefaultConfigurationFileName(clazz);
        ClassPathResource resource = new ClassPathResource(fileName, clazz);
        if (resource.exists()) {
            Map configurationByClass = this.loadConfigurations((Resource)resource);
            this.configurationByClass.putAll(configurationByClass);
            return (BeanValidationConfiguration)configurationByClass.get(clazz);
        }
        logger.warn((Object)("Could not find the default validation configuration for class '" + clazz.getName() + "'"));
        this.configurationByClass.put(clazz, null);
        return null;
    }

    protected String createDefaultConfigurationFileName(Class clazz) {
        return ClassUtils.getShortName((Class)clazz) + DEFAULT_RESOURCE_EXTENTION;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

