/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.glassfish;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.springframework.instrument.classloading.glassfish.ClassTransformerAdapter;

class GlassFishClassLoaderAdapter {
    static final String INSTRUMENTABLE_CLASSLOADER_GLASSFISH_V2 = "com.sun.enterprise.loader.InstrumentableClassLoader";
    static final String INSTRUMENTABLE_CLASSLOADER_GLASSFISH_V3 = "org.glassfish.api.deployment.InstrumentableClassLoader";
    private static final String CLASS_TRANSFORMER = "javax.persistence.spi.ClassTransformer";
    private final ClassLoader classLoader;
    private final Method addTransformer;
    private final Method copy;
    private final boolean glassFishV3;

    public GlassFishClassLoaderAdapter(ClassLoader classLoader) {
        Class<?> instrumentableLoaderClass;
        boolean glassV3 = false;
        try {
            instrumentableLoaderClass = classLoader.loadClass(INSTRUMENTABLE_CLASSLOADER_GLASSFISH_V2);
        }
        catch (ClassNotFoundException ex) {
            try {
                instrumentableLoaderClass = classLoader.loadClass(INSTRUMENTABLE_CLASSLOADER_GLASSFISH_V3);
                glassV3 = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException("Could not initialize GlassFish LoadTimeWeaver because GlassFish (V1, V2 or V3) API classes are not available", ex);
            }
        }
        try {
            Class<ClassFileTransformer> classTransformerClass = glassV3 ? ClassFileTransformer.class : classLoader.loadClass(CLASS_TRANSFORMER);
            this.addTransformer = instrumentableLoaderClass.getMethod("addTransformer", classTransformerClass);
            this.copy = instrumentableLoaderClass.getMethod("copy", new Class[0]);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not initialize GlassFish LoadTimeWeaver because GlassFish API classes are not available", ex);
        }
        ClassLoader clazzLoader = null;
        ClassLoader cl = classLoader;
        while (cl != null && clazzLoader == null) {
            if (instrumentableLoaderClass.isInstance(cl)) {
                clazzLoader = cl;
            }
            cl = cl.getParent();
        }
        if (clazzLoader == null) {
            throw new IllegalArgumentException(classLoader + " and its parents are not suitable ClassLoaders: A [" + instrumentableLoaderClass.getName() + "] implementation is required.");
        }
        this.classLoader = clazzLoader;
        this.glassFishV3 = glassV3;
    }

    public void addTransformer(ClassFileTransformer transformer) {
        try {
            this.addTransformer.invoke((Object)this.classLoader, this.glassFishV3 ? transformer : new ClassTransformerAdapter(transformer));
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException("GlassFish addTransformer method threw exception ", ex.getCause());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not invoke GlassFish addTransformer method", ex);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassLoader getThrowawayClassLoader() {
        try {
            return (ClassLoader)this.copy.invoke((Object)this.classLoader, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException("GlassFish copy method threw exception ", ex.getCause());
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not invoke GlassFish copy method", ex);
        }
    }
}

