package com.jispot.services.impl;

import java.util.logging.Logger;

import org.springframework.stereotype.Service;

import com.jispot.domain.model.Spotter;
import com.jispot.services.ConnectionService;

@Service("connectionService")
public class ConnectionServiceImpl implements ConnectionService {

	protected final Logger log = Logger.getLogger(this.getClass().getName());

	public Spotter login(String login, String password) {
		Spotter obj = Spotter.all().filter("login", login).filter("password",
				password).get();
		return obj;
	}

	public boolean isOk(String login, String password) {
		return login(login, password) != null;
	}

	/**
	 * Subscription with login == email. Usefull for the standart registration
	 * way... not convenient for openId registration
	 * 
	 * @param email
	 * @param firstname
	 * @param lastname
	 * @param password
	 * @param confirm
	 */
	public void subscribe(final String email, final String firstname,
			final String lastname, final String password) {
		subscribe(email, email, firstname, lastname, password);
	}

	/**
	 * Subscription with login == email. Usefull for the openid registration way
	 * 
	 * @param email
	 * @param login could represent the openid identifier on the email depending on the registration style
	 * @param firstname
	 * @param lastname
	 * @param password
	 * @param confirm
	 */
	public void subscribe(final String email, final String login,
			final String firstname, final String lastname, final String password) {

		Spotter obj = new Spotter();
		obj.email = email;
		obj.login = login;
		obj.firstName = firstname;
		obj.lastName = lastname;
		obj.password = password;
		obj.insert();
	}

}
