package com.jispot.web.spot;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import com.jispot.web.JISpotAjaxController;
import com.jispot.web.vo.CoordinateVO;

@Controller("spotMeController")
public class SpotMeController extends JISpotAjaxController {

    protected final Logger log = Logger.getLogger(this.getClass().getName());

    /**
     * Retourne un marqueur sur la position courante du spotter.
     */
    @RequestMapping(value = "/jispot/spotme.html", method = RequestMethod.GET)
    public void getCurrentPosition(HttpServletRequest request, HttpServletResponse response,
    		@RequestParam(value = "userId", required = false) Long userId) {
        super.init(request, response);
        log.info("SpotMeController.getCurrentPosition called!");

        if (userId == null) {
        	userId = getUserId();
        }
        // IBIX : Get the data from database
        
        CoordinateVO coord = new CoordinateVO("43.566296", "-1.464761", 
                "Drag me to the right spot!", request.getContextPath() +"/static/img/gmaps/regroup.png");

        super.sendJsonResult(coord);
    }
    /**
     * Retourne un marqueur sur la position courante du spotter.
     */
    @RequestMapping(value = "/jispot/spotme.html", method = RequestMethod.POST)
    public void setPosition(HttpServletRequest request, HttpServletResponse response,
            @RequestParam(value = "fieldDescription", required = true) final String description,
            @RequestParam(value = "fieldForever", required = true) final String forever,
            @RequestParam(value = "fieldDateFrom", required = true) final String dateFrom,
            @RequestParam(value = "fieldDateTo", required = true) final String dateTo,
            @RequestParam(value = "fieldLat", required = true) final String latitude,
            @RequestParam(value = "fieldLng", required = true) final String longitude) {

        super.init(request, response);

        log.info("MapSpotController.setPosition called!");
        log.info("Description : " + description);
        log.info("Forever     : " + forever);
        log.info("Date From   : " + dateFrom);
        log.info("Date To     : " + dateTo);
        log.info("Latitude    : " + latitude);
        log.info("Longitude   : " + longitude);

        // 
        // IBIX : Set the current Position into database
        
        
        // return result
        Map<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("result", "OK");
        resultMap.put("message", "Position saved!");
        
        super.sendJsonResult(resultMap);
    }

}
