/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc;

import com.google.cloud.sql.jdbc.Connection;
import com.google.cloud.sql.jdbc.ResultSet;
import com.google.cloud.sql.jdbc.Statement;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.ExecResponse;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class StreamingResultSet
extends ResultSet {
    private final Connection conn;
    private final long statementId;
    boolean moreRows;

    public StreamingResultSet(Statement stmt, Client.ResultProto result, SQLWarning warnings, String catalog, SqlRpcOptions rpcOptions, long statementId) {
        super(stmt, result.getRows().getTuplesList(), result.getRows().getColumnsList(), warnings, catalog, rpcOptions);
        this.moreRows = result.getMoreRows();
        try {
            this.conn = stmt.getConnection();
        }
        catch (SQLException e) {
            throw new IllegalStateException("getConnection should not throw exception.", e);
        }
        this.statementId = statementId;
    }

    public boolean next() throws SQLException {
        boolean next = super.next();
        if (!next && this.moreRows) {
            ExecResponse response = this.conn.executeNext(this.getRpcOptions(), this.statementId);
            if (!response.hasResult()) {
                this.moreRows = false;
                return false;
            }
            Client.ResultProto result = response.getResult();
            this.moreRows = result.getMoreRows();
            return this.setData(result.getRows().getTuplesList());
        }
        return next;
    }
}

