/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.util.ArrayList;
import java.util.List;
import javax.mail.EventQueue;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.event.ConnectionEvent;
import javax.mail.event.ConnectionListener;
import javax.mail.event.FolderEvent;
import javax.mail.event.FolderListener;
import javax.mail.event.MailEvent;
import javax.mail.event.MessageChangedEvent;
import javax.mail.event.MessageChangedListener;
import javax.mail.event.MessageCountEvent;
import javax.mail.event.MessageCountListener;
import javax.mail.search.SearchTerm;

public abstract class Folder {
    public static final int HOLDS_MESSAGES = 1;
    public static final int HOLDS_FOLDERS = 2;
    public static final int READ_ONLY = 1;
    public static final int READ_WRITE = 2;
    protected Store store;
    protected int mode = -1;
    private final ArrayList connectionListeners = new ArrayList(2);
    private final ArrayList folderListeners = new ArrayList(2);
    private final ArrayList messageChangedListeners = new ArrayList(2);
    private final ArrayList messageCountListeners = new ArrayList(2);
    private EventQueue queue = null;

    protected Folder(Store store) {
        this.store = store;
    }

    public abstract String getName();

    public abstract String getFullName();

    public URLName getURLName() throws MessagingException {
        URLName baseURL = this.store.getURLName();
        return new URLName(baseURL.getProtocol(), baseURL.getHost(), baseURL.getPort(), this.getFullName(), baseURL.getUsername(), null);
    }

    public Store getStore() {
        return this.store;
    }

    public abstract Folder getParent() throws MessagingException;

    public abstract boolean exists() throws MessagingException;

    public abstract Folder[] list(String var1) throws MessagingException;

    public Folder[] listSubscribed(String pattern) throws MessagingException {
        return this.list(pattern);
    }

    public Folder[] list() throws MessagingException {
        return this.list("%");
    }

    public Folder[] listSubscribed() throws MessagingException {
        return this.listSubscribed("%");
    }

    public abstract char getSeparator() throws MessagingException;

    public abstract int getType() throws MessagingException;

    public abstract boolean create(int var1) throws MessagingException;

    public boolean isSubscribed() {
        return true;
    }

    public void setSubscribed(boolean subscribed) throws MessagingException {
        throw new MethodNotSupportedException();
    }

    public abstract boolean hasNewMessages() throws MessagingException;

    public abstract Folder getFolder(String var1) throws MessagingException;

    public abstract boolean delete(boolean var1) throws MessagingException;

    public abstract boolean renameTo(Folder var1) throws MessagingException;

    public abstract void open(int var1) throws MessagingException;

    public abstract void close(boolean var1) throws MessagingException;

    public abstract boolean isOpen();

    public int getMode() {
        return this.mode;
    }

    public abstract Flags getPermanentFlags();

    public abstract int getMessageCount() throws MessagingException;

    public int getNewMessageCount() throws MessagingException {
        return this.getCount(Flags.Flag.RECENT, true);
    }

    public int getUnreadMessageCount() throws MessagingException {
        return this.getCount(Flags.Flag.SEEN, false);
    }

    public int getDeletedMessageCount() throws MessagingException {
        return this.getCount(Flags.Flag.DELETED, true);
    }

    private int getCount(Flags.Flag flag, boolean value) throws MessagingException {
        if (!this.isOpen()) {
            return -1;
        }
        Message[] messages = this.getMessages();
        int total = 0;
        for (int i = 0; i < messages.length; ++i) {
            if (messages[i].getFlags().contains(flag) != value) continue;
            ++total;
        }
        return total;
    }

    public abstract Message getMessage(int var1) throws MessagingException;

    public Message[] getMessages(int start, int end) throws MessagingException {
        Message[] result = new Message[end - start + 1];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getMessage(start++);
        }
        return result;
    }

    public Message[] getMessages(int[] ids) throws MessagingException {
        Message[] result = new Message[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            result[i] = this.getMessage(ids[i]);
        }
        return result;
    }

    public Message[] getMessages() throws MessagingException {
        return this.getMessages(1, this.getMessageCount());
    }

    public abstract void appendMessages(Message[] var1) throws MessagingException;

    public void fetch(Message[] messages, FetchProfile profile) throws MessagingException {
    }

    public void setFlags(Message[] messages, Flags flags, boolean value) throws MessagingException {
        for (int i = 0; i < messages.length; ++i) {
            Message message = messages[i];
            message.setFlags(flags, value);
        }
    }

    public void setFlags(int start, int end, Flags flags, boolean value) throws MessagingException {
        for (int i = start; i <= end; ++i) {
            Message message = this.getMessage(i);
            message.setFlags(flags, value);
        }
    }

    public void setFlags(int[] ids, Flags flags, boolean value) throws MessagingException {
        for (int i = 0; i < ids.length; ++i) {
            Message message = this.getMessage(ids[i]);
            message.setFlags(flags, value);
        }
    }

    public void copyMessages(Message[] messages, Folder folder) throws MessagingException {
        folder.appendMessages(messages);
    }

    public abstract Message[] expunge() throws MessagingException;

    public Message[] search(SearchTerm term) throws MessagingException {
        return this.search(term, this.getMessages());
    }

    public Message[] search(SearchTerm term, Message[] messages) throws MessagingException {
        ArrayList<Message> result = new ArrayList<Message>(messages.length);
        for (int i = 0; i < messages.length; ++i) {
            Message message = messages[i];
            if (!message.match(term)) continue;
            result.add(message);
        }
        return result.toArray(new Message[result.size()]);
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    protected void notifyConnectionListeners(int type) {
        this.queueEvent(new ConnectionEvent(this, type), this.connectionListeners);
    }

    public void addFolderListener(FolderListener listener) {
        this.folderListeners.add(listener);
    }

    public void removeFolderListener(FolderListener listener) {
        this.folderListeners.remove(listener);
    }

    protected void notifyFolderListeners(int type) {
        this.queueEvent(new FolderEvent(this, this, type), this.folderListeners);
    }

    protected void notifyFolderRenamedListeners(Folder newFolder) {
        this.queueEvent(new FolderEvent(this, this, newFolder, 3), this.folderListeners);
    }

    public void addMessageCountListener(MessageCountListener listener) {
        this.messageCountListeners.add(listener);
    }

    public void removeMessageCountListener(MessageCountListener listener) {
        this.messageCountListeners.remove(listener);
    }

    protected void notifyMessageAddedListeners(Message[] messages) {
        this.queueEvent(new MessageCountEvent(this, 1, false, messages), this.messageChangedListeners);
    }

    protected void notifyMessageRemovedListeners(boolean removed, Message[] messages) {
        this.queueEvent(new MessageCountEvent(this, 2, removed, messages), this.messageChangedListeners);
    }

    public void addMessageChangedListener(MessageChangedListener listener) {
        this.messageChangedListeners.add(listener);
    }

    public void removeMessageChangedListener(MessageChangedListener listener) {
        this.messageChangedListeners.remove(listener);
    }

    protected void notifyMessageChangedListeners(int type, Message message) {
        this.queueEvent(new MessageChangedEvent(this, type, message), this.messageChangedListeners);
    }

    protected void finalize() throws Throwable {
        if (this.queue != null) {
            this.queue.stop();
            this.queue = null;
        }
        this.connectionListeners.clear();
        this.folderListeners.clear();
        this.messageChangedListeners.clear();
        this.messageCountListeners.clear();
        this.store = null;
        super.finalize();
    }

    public String toString() {
        String name = this.getFullName();
        return name == null ? super.toString() : name;
    }

    private synchronized void queueEvent(MailEvent event, ArrayList listeners) {
        if (listeners.isEmpty()) {
            return;
        }
        if (this.queue == null) {
            this.queue = new EventQueue();
        }
        this.queue.queueEvent(event, (List)listeners.clone());
    }
}

