/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.MetaDataUtils;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.query.IncompatibleQueryElementTypeException;
import org.datanucleus.store.mapped.scostore.AbstractArrayStore;
import org.datanucleus.store.mapped.scostore.ElementContainerStore;
import org.datanucleus.store.mapped.scostore.JoinArrayStoreSpecialization;
import org.datanucleus.util.ClassUtils;

public abstract class JoinArrayStore
extends AbstractArrayStore {
    public JoinArrayStore(DatastoreContainerObject joinTable, AbstractMemberMetaData ownerFieldMetaData, JavaTypeMapping ownerMapping, JavaTypeMapping elementMapping, JavaTypeMapping orderMapping, JavaTypeMapping relationDiscriminatorMapping, String relationDiscriminatorValue, String elementType, boolean elementsAreEmbedded, boolean elementsAreSerialised, ClassLoaderResolver clr, JoinArrayStoreSpecialization specialization) {
        super((StoreManager)joinTable.getStoreManager(), clr, specialization);
        this.containerTable = joinTable;
        this.setOwner(ownerFieldMetaData, clr);
        this.ownerMapping = ownerMapping;
        this.elementMapping = elementMapping;
        this.orderMapping = orderMapping;
        this.relationDiscriminatorMapping = relationDiscriminatorMapping;
        this.relationDiscriminatorValue = relationDiscriminatorValue;
        this.elementType = elementType;
        this.elementsAreEmbedded = elementsAreEmbedded;
        this.elementsAreSerialised = elementsAreSerialised;
        if (this.elementsAreSerialised) {
            this.elementInfo = null;
        } else {
            Class element_class = clr.classForName(elementType);
            if (ClassUtils.isReferenceType(element_class)) {
                String[] implNames = MetaDataUtils.getInstance().getImplementationNamesForReferenceField(this.ownerMemberMetaData, 4, clr);
                this.elementInfo = new ElementContainerStore.ElementInfo[implNames.length];
                for (int i = 0; i < implNames.length; ++i) {
                    DatastoreClass table = this.storeMgr.getDatastoreClass(implNames[i], clr);
                    AbstractClassMetaData cmd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(implNames[i], clr);
                    this.elementInfo[i] = new ElementContainerStore.ElementInfo(cmd, table);
                }
            } else {
                this.emd = this.storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(element_class, clr);
                if (this.emd != null) {
                    elementType = this.emd.getFullClassName();
                    if (!elementsAreEmbedded && !elementsAreSerialised) {
                        this.elementInfo = this.getElementInformationForClass();
                        if (this.elementInfo != null && this.elementInfo.length > 1) {
                            throw new NucleusUserException(LOCALISER.msg("056045", (Object)this.ownerMemberMetaData.getFullFieldName()));
                        }
                    } else {
                        this.elementInfo = null;
                    }
                } else {
                    this.elementInfo = null;
                }
            }
        }
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression parentStmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier listTableAlias, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementTableAlias) {
        ClassLoaderResolver clr = stmt.getClassLoaderResolver();
        Class primitiveType = ClassUtils.getWrapperTypeForPrimitiveType(clr.classForName(this.elementType));
        if (!clr.isAssignableFrom(this.elementType, filteredElementType) && !clr.isAssignableFrom(filteredElementType, this.elementType) && primitiveType != null && clr.isAssignableFrom(this.elementType, primitiveType.getName())) {
            throw new IncompatibleQueryElementTypeException(this.elementType, filteredElementType.getName());
        }
        LogicSetExpression ownTblExpr = stmt.newTableExpression(this.containerTable, listTableAlias);
        ScalarExpression ownerExpr = ownerMapping.newScalarExpression(stmt, ownerTe);
        ScalarExpression ownerSetExpr = this.ownerMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        if (!parentStmt.hasCrossJoin(ownTblExpr)) {
            stmt.crossJoin(ownTblExpr, true);
        }
        stmt.andCondition(ownerExpr.eq(ownerSetExpr), true);
        if (this.storeMgr.getMappedTypeManager().isSupportedMappedType(filteredElementType.getName())) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        }
        if (this.elementsAreEmbedded || this.elementsAreSerialised) {
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        }
        DatastoreClass elementTable = this.storeMgr.getDatastoreClass(filteredElementType.getName(), stmt.getClassLoaderResolver());
        DatastoreClass joiningClass = elmExpr.getLogicSetExpression() == null ? elementTable : (DatastoreClass)elmExpr.getLogicSetExpression().getMainTable();
        JavaTypeMapping elementTableID = joiningClass.getIDMapping();
        LogicSetExpression elmTblExpr = stmt.getTableExpression(elementTableAlias);
        if (elmTblExpr == null) {
            elmTblExpr = stmt.newTableExpression(elementTable, elementTableAlias);
        }
        ScalarExpression elmSetExpr = this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        if (!parentStmt.hasCrossJoin(elmTblExpr)) {
            stmt.crossJoin(elmTblExpr, true);
        }
        if (elmExpr.getLogicSetExpression() != null && !elementTable.equals(elmExpr.getLogicSetExpression().getMainTable())) {
            stmt.andCondition(elmSetExpr.eq(elmExpr), true);
            return this.elementMapping.newScalarExpression(stmt, stmt.getTableExpression(listTableAlias));
        }
        ScalarExpression elementExpr = elementTableID.newScalarExpression(stmt, stmt.getTableExpression(elementTableAlias));
        stmt.andCondition(elmSetExpr.eq(elementExpr), true);
        return elementExpr;
    }
}

