/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Query;
import java.util.Date;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobInfoFactory {
    public static final String KIND = "__BlobInfo__";
    public static final String CONTENT_TYPE = "content_type";
    public static final String CREATION = "creation";
    public static final String FILENAME = "filename";
    public static final String SIZE = "size";
    private final DatastoreService datastoreService;

    public BlobInfoFactory() {
        this(DatastoreServiceFactory.getDatastoreService());
    }

    public BlobInfoFactory(DatastoreService datastoreService) {
        this.datastoreService = datastoreService;
    }

    public BlobInfo loadBlobInfo(BlobKey blobKey) {
        try {
            return this.createBlobInfo(this.datastoreService.get(this.getMetadataKeyForBlobKey(blobKey)));
        }
        catch (EntityNotFoundException ex) {
            return null;
        }
    }

    public Iterator<BlobInfo> queryBlobInfos() {
        return this.queryBlobInfosAfter(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<BlobInfo> queryBlobInfosAfter(BlobKey previousBlob) {
        Query query;
        String origNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set("");
            query = new Query(KIND, null);
        }
        finally {
            NamespaceManager.set(origNamespace);
        }
        if (previousBlob != null) {
            query.addFilter("__key__", Query.FilterOperator.GREATER_THAN, this.getMetadataKeyForBlobKey(previousBlob));
        }
        final Iterator<Entity> parent = this.datastoreService.prepare(query).asIterator();
        return new Iterator<BlobInfo>(){

            @Override
            public boolean hasNext() {
                return parent.hasNext();
            }

            @Override
            public BlobInfo next() {
                return BlobInfoFactory.this.createBlobInfo((Entity)parent.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public BlobInfo createBlobInfo(Entity entity) {
        return new BlobInfo(new BlobKey(entity.getKey().getName()), (String)entity.getProperty(CONTENT_TYPE), (Date)entity.getProperty(CREATION), (String)entity.getProperty(FILENAME), (Long)entity.getProperty(SIZE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key getMetadataKeyForBlobKey(BlobKey blobKey) {
        String origNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set("");
            Key key = KeyFactory.createKey(null, KIND, blobKey.getKeyString());
            return key;
        }
        finally {
            NamespaceManager.set(origNamespace);
        }
    }
}

