/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request;

import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;

public class Log4jNestedDiagnosticContextInterceptor
implements WebRequestInterceptor {
    protected final Logger log4jLogger = Logger.getLogger(this.getClass());
    private boolean includeClientInfo = false;

    public void setIncludeClientInfo(boolean includeClientInfo) {
        this.includeClientInfo = includeClientInfo;
    }

    protected boolean isIncludeClientInfo() {
        return this.includeClientInfo;
    }

    public void preHandle(WebRequest request) throws Exception {
        NDC.push((String)this.getNestedDiagnosticContextMessage(request));
    }

    protected String getNestedDiagnosticContextMessage(WebRequest request) {
        return request.getDescription(this.isIncludeClientInfo());
    }

    public void postHandle(WebRequest request, ModelMap model) throws Exception {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws Exception {
        NDC.pop();
        if (NDC.getDepth() == 0) {
            NDC.remove();
        }
    }
}

