/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.jdo;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Category;
import com.google.appengine.api.datastore.Email;
import com.google.appengine.api.datastore.GeoPt;
import com.google.appengine.api.datastore.IMHandle;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Link;
import com.google.appengine.api.datastore.PhoneNumber;
import com.google.appengine.api.datastore.PostalAddress;
import com.google.appengine.api.datastore.Rating;
import com.google.appengine.api.datastore.ShortBlob;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.api.users.User;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Set;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.OMFContext;
import org.datanucleus.jdo.metadata.JDOMetaDataManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ArrayMetaData;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.metadata.FieldPersistenceModifier;
import org.datanucleus.store.appengine.Utils;

public class DatastoreJDOMetaDataManager
extends JDOMetaDataManager {
    private static final Set<Class<?>> DEFAULT_FETCH_GROUP_TYPE_OVERRIDES = Utils.newHashSet(Blob.class, Category.class, Email.class, GeoPt.class, IMHandle.class, Key.class, Link.class, PhoneNumber.class, PostalAddress.class, Rating.class, ShortBlob.class, Text.class, BlobKey.class, User.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Integer.TYPE, Integer.class, Short.TYPE, Short.class, Character.TYPE, Character.class, Long.TYPE, Long.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Date.class, Enum.class, String.class);
    private static final Field JDO_FIELD_FLAG_FIELD;

    public DatastoreJDOMetaDataManager(OMFContext ctxt) {
        super(ctxt);
    }

    protected void populateAbstractClassMetaData(AbstractClassMetaData acmd, ClassLoaderResolver clr, ClassLoader loader) {
        super.populateAbstractClassMetaData(acmd, clr, loader);
        for (int i = 0; i < acmd.getNoOfMembers(); ++i) {
            AbstractMemberMetaData ammd = acmd.getMetaDataForMemberAtRelativePosition(i);
            Class<?> elementType = null;
            if (ammd.getContainer() instanceof CollectionMetaData) {
                elementType = clr.classForName(((CollectionMetaData)ammd.getContainer()).getElementType());
            } else if (ammd.getContainer() instanceof ArrayMetaData) {
                elementType = ammd.getType().getComponentType();
            }
            if (elementType == null || ammd.isDefaultFetchGroup() || ammd.getPersistenceModifier().equals((Object)FieldPersistenceModifier.NONE) || ammd.getPersistenceModifier().equals((Object)FieldPersistenceModifier.TRANSACTIONAL) || !this.shouldBeInDefaultFetchGroup(elementType)) continue;
            this.moveToDefaultFetchGroup(ammd);
        }
    }

    private boolean shouldBeInDefaultFetchGroup(Class elementType) {
        if (DEFAULT_FETCH_GROUP_TYPE_OVERRIDES.contains(elementType)) {
            return true;
        }
        return !elementType.equals(Object.class) && this.shouldBeInDefaultFetchGroup(elementType.getSuperclass());
    }

    private void moveToDefaultFetchGroup(AbstractMemberMetaData ammd) {
        ammd.setDefaultFetchGroup(true);
        int serializable = 0;
        if (Serializable.class.isAssignableFrom(ammd.getType()) || ammd.getType().isPrimitive()) {
            serializable = 16;
        }
        byte jdoFieldFlag = (byte)(5 | serializable);
        try {
            JDO_FIELD_FLAG_FIELD.set(ammd, jdoFieldFlag);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            JDO_FIELD_FLAG_FIELD = AbstractMemberMetaData.class.getDeclaredField("jdoFieldFlag");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        JDO_FIELD_FLAG_FIELD.setAccessible(true);
    }
}

