package com.jispot.web;

import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.VerificationResult;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.Identifier;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.AxMessage;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.Validator;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller("openIdController")
public class OpenIdController {

    protected final Logger log = Logger.getLogger(this.getClass().getName());

//    @Autowired
//    private ConnectionService connectionService;
    
    @Autowired
    Validator validator;

    /**
     * Handler de la methode Get pour l'URL /getInfos.html.
     *
     * @param model Une map des donnees qui sont utilisables dans la vue
     * @return <code>home</code> La page de redirection : /WEB-INF/jsp/home.jsp.
     */
    @SuppressWarnings("unchecked")
    @RequestMapping(value = "/login/openid.html")
    public String openid(@RequestParam(value = "openid_username", required = false) final String username,
                         @RequestParam(value = "openid_identifier", required = false) final String identifier,
                         final ModelMap model,
                         HttpServletRequest request,
                         HttpServletResponse response) {
    	log.info("LoginController.getOpenIdUrl called !");
        log.info("Username = " + username);
        log.info("Identifier = " + identifier);

        try {
            HttpSession session = request.getSession();
            ConsumerManager manager = new ConsumerManager();

            // Redirect to the right openId provider :
            // perform discovery on the user-supplied identifier
            List discoveries = manager.discover(identifier);

            // attempt to associate with the OpenID provider
            // and retrieve one service endpoint for authentication
            DiscoveryInformation discovered = manager.associate(discoveries);

            // store the discovery information in the user's session for later use
            // leave out for stateless operation / if there is no session
            session.setAttribute("openid-discovered", discovered);
            session.setAttribute("openid-manager", manager);

            // obtain a AuthRequest message to be sent to the OpenID provider
            AuthRequest authReq = manager.authenticate(discovered, "http://localhost:8080/login/openid/result.html");

            // Attribute Exchange example: fetching the 'email' attribute
            FetchRequest fetch = FetchRequest.createFetchRequest();
            fetch.addAttribute("firstName", "http://schema.openid.net/namePerson/first", true);
            fetch.addAttribute("lastName", "http://schema.openid.net/namePerson/last", true);
            fetch.addAttribute("email", "http://schema.openid.net/contact/email", true);
            // attach the extension to the authentication request
            authReq.addExtension(fetch);


//            if (! discovered.isVersion2() ) {
            log.info("OpenId version 1");
                // Option 1: GET HTTP-redirect to the OpenID Provider endpoint
                // The only method supported in OpenID 1.x
                // redirect-URL usually limited ~2048 bytes
                response.sendRedirect(authReq.getDestinationUrl(true));
//            }
//            else {
//                LOG.info("OpenId version 2");
//                // Option 2: HTML FORM Redirection (Allows payloads >2048 bytes)
//
//                RequestDispatcher dispatcher = request.getRequestDispatcher("login.html");
//                request.setAttribute("parameterMap", authReq.getParameterMap());
//                request.setAttribute("destinationUrl", authReq.getDestinationUrl(false));
//                dispatcher.forward(request, response);
//            }

        
        } catch (Exception e) {
            e.printStackTrace();
        }

		return "index";
    }

    /**
     * Handler de la methode Get pour l'URL /getInfos.html.
     *
     * Google     : https://www.google.com/accounts/o8/id?id=AItOawkwqwhcuNfmYVZZCVSzJUGqhcGcH2tJx4s    / email OK
     * Yahoo      : https://me.yahoo.com/a/h.9D7.8DxYZXiWclxPMlUn0g3T7d                                 / email KO
     *              https://me.yahoo.com/a/h.9D7.8DxYZXiWclxPMlUn0g3T7d#c8629
     * OpenId.net : http://ledruide.myopenid.com/                                                       / email KO
     * @param model ModelMap stuff
     * @param request the HttpRequest
     * @param response the HttpResponse
     * @return <code>home</code> La page de redirection : /WEB-INF/jsp/home.jsp.
     */
    @SuppressWarnings("unchecked")
    @RequestMapping(value = "/login/openid/result.html")
    public String openIdResult(final ModelMap model,HttpServletRequest request, HttpServletResponse response) {
    	log.info("LoginController.getReturnUrl called !");
        try {
            HttpSession session = request.getSession();
            ConsumerManager manager = (ConsumerManager) session.getAttribute("openid-manager");

            // extract the parameters from the authentication response
            // (which comes in as a HTTP request from the OpenID provider)
            ParameterList openidResp = new ParameterList(request.getParameterMap());

            // retrieve the previously stored discovery information
            DiscoveryInformation discovered = (DiscoveryInformation) session.getAttribute("openid-discovered");

            // extract the receiving URL from the HTTP request
            StringBuffer receivingURL = request.getRequestURL();
            String queryString = request.getQueryString();
            if (queryString != null && queryString.length() > 0) {
                receivingURL.append("?").append(request.getQueryString());
            }
            log.info("receivingURL = " + receivingURL);
            // verify the response
            VerificationResult verification = manager.verify(receivingURL.toString(), openidResp, discovered);

            // examine the verification result and extract the verified identifier
            Identifier verified = verification.getVerifiedId();

            if (verified != null) {
                // success, use the verified identifier to identify the user
                AuthSuccess authSuccess = (AuthSuccess) verification.getAuthResponse();

                if (authSuccess.hasExtension(AxMessage.OPENID_NS_AX)) {
                    FetchResponse fetchResp = (FetchResponse) authSuccess.getExtension(AxMessage.OPENID_NS_AX);
                    Map attribs = fetchResp.getAttributes();
                    for (Object o : attribs.keySet()) {
                        String key = (String) o;
//                        LOG.info(key + " = " + attribs.get(key));
                        log.info("Key = " + key);
                    }

                    List emails = fetchResp.getAttributeValues("email");
                    String email = (String) emails.get(0);
                    log.info("Email = " + email);
                }
                // KLOUG We need to test if the user is already known
                log.info("VERIFIED ID = " + verification.getVerifiedId());
                session.setAttribute(Constants.SESSION_USER_ID, verification.getVerifiedId());
                //model.addAttribute(Constants.ATTRIBUTE_PAGE, Constants.PAGE_LOGIN_SUCCEED);
            }
            else {
                // OpenID authentication failed
                //model.addAttribute(Constants.ATTRIBUTE_PAGE, Constants.PAGE_LOGIN_FAILED);
            }
        }
        catch (Exception e) {
        	log.severe(e.getMessage());
            e.printStackTrace();
        }

        return "index";
    }

    
}
