/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.identity.OID;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.IdentityType;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.expression.BooleanBitColumnExpression;
import org.datanucleus.store.mapped.expression.BooleanExpression;
import org.datanucleus.store.mapped.expression.BooleanLiteral;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.NullLiteral;
import org.datanucleus.store.mapped.expression.ObjectExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.EmbeddedMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.NucleusLogger;

public class ObjectLiteral
extends ObjectExpression
implements Literal {
    private Object value;
    Object rawValue;
    private String mappingClass;

    public ObjectLiteral(QueryExpression qs, JavaTypeMapping mapping, Object value) {
        super(qs);
        this.st.appendParameter(mapping, value);
        this.mapping = mapping;
        this.value = value;
    }

    public ObjectLiteral(QueryExpression qs, JavaTypeMapping mapping, Object value, String mappingClass) {
        super(qs);
        this.st.appendParameter(mapping, value);
        this.value = value;
        this.mapping = mapping;
        this.mappingClass = mappingClass;
    }

    public Object getValue() {
        return this.value;
    }

    public BooleanExpression eq(ScalarExpression expr) {
        if (expr instanceof ObjectLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, this.value.equals(((ObjectLiteral)expr).value));
        }
        if (expr instanceof BooleanBitColumnExpression) {
            return null;
        }
        if (expr instanceof ObjectExpression) {
            BooleanExpression bExpr = this.getEqualityExpressionForObjectExpression((ObjectExpression)expr);
            return bExpr;
        }
        return super.eq(expr);
    }

    public BooleanExpression noteq(ScalarExpression expr) {
        if (expr instanceof ObjectLiteral) {
            return new BooleanLiteral(this.qs, this.mapping, !this.value.equals(((ObjectLiteral)expr).value));
        }
        if (expr instanceof ObjectExpression) {
            BooleanExpression bExpr = this.getEqualityExpressionForObjectExpression((ObjectExpression)expr);
            bExpr = new BooleanExpression(this, OP_NOTEQ, bExpr);
            return bExpr;
        }
        return super.noteq(expr);
    }

    private BooleanExpression getEqualityExpressionForObjectExpression(ObjectExpression expr) {
        BooleanExpression bExpr = null;
        if (this.value == null) {
            bExpr = expr.eq(new NullLiteral(this.qs));
        } else {
            MappedStoreManager storeMgr = this.qs.getStoreManager();
            ClassLoaderResolver clr = this.qs.getClassLoaderResolver();
            if (this.value instanceof OID) {
                JavaTypeMapping m = storeMgr.getMappingManager().getMappingWithDatastoreMapping(((OID)this.value).getKeyValue().getClass(), false, false, clr);
                ScalarExpression oidExpr = m.newLiteral(this.qs, ((OID)this.value).getKeyValue());
                bExpr = expr.expressionList.getExpression(0).eq(oidExpr);
            } else {
                ApiAdapter api = this.qs.getStoreManager().getApiAdapter();
                AbstractClassMetaData cmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(this.value.getClass(), clr);
                if (cmd == null) {
                    if (storeMgr.getApiAdapter().isSingleFieldIdentityClass(this.value.getClass().getName())) {
                        JavaTypeMapping m = storeMgr.getMappingManager().getMappingWithDatastoreMapping(api.getTargetClassForSingleFieldIdentity(this.value), false, false, clr);
                        ScalarExpression oidExpr = m.newLiteral(this.qs, api.getTargetKeyForSingleFieldIdentity(this.value));
                        bExpr = expr.expressionList.getExpression(0).eq(oidExpr);
                    } else {
                        String pcClassName = storeMgr.getClassNameForObjectID(this.value, clr, null);
                        if (pcClassName != null) {
                            cmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(pcClassName, clr);
                            bExpr = this.eqApplicationIdentity(this.value, null, expr, null, storeMgr, clr, cmd);
                        } else {
                            bExpr = new BooleanLiteral(this.qs, this.mapping, false).eq(new BooleanLiteral(this.qs, this.mapping, true));
                        }
                    }
                } else if (cmd.getIdentityType() == IdentityType.APPLICATION) {
                    if (api.getIdForObject(this.value) != null) {
                        int i;
                        JavaTypeMapping[] pkMappingsApp = new JavaTypeMapping[expr.expressionList.size()];
                        Object[] pkFieldValues = new Object[expr.expressionList.size()];
                        int position = 0;
                        for (i = 0; i < cmd.getNoOfPrimaryKeyMembers(); ++i) {
                            AbstractMemberMetaData mmd = cmd.getMetaDataForManagedMemberAtAbsolutePosition(cmd.getPKMemberPositions()[i]);
                            Object fieldValue = this.getFieldValue(mmd, this.value);
                            JavaTypeMapping mapping = storeMgr.getMappingManager().getMappingWithDatastoreMapping(fieldValue.getClass(), false, false, clr);
                            if (mapping instanceof PersistenceCapableMapping) {
                                position = this.populatePrimaryKeyMappingsValuesForPCMapping(pkMappingsApp, pkFieldValues, position, (PersistenceCapableMapping)mapping, cmd, mmd, fieldValue, storeMgr, clr);
                                continue;
                            }
                            pkMappingsApp[position] = mapping;
                            pkFieldValues[position] = fieldValue;
                            ++position;
                        }
                        for (i = 0; i < expr.expressionList.size(); ++i) {
                            ScalarExpression source = expr.expressionList.getExpression(i);
                            ScalarExpression target = pkMappingsApp[i].newLiteral(this.qs, pkFieldValues[i]);
                            bExpr = bExpr == null ? source.eq(target) : bExpr.and(source.eq(target));
                        }
                    } else {
                        for (int i = 0; i < expr.expressionList.size(); ++i) {
                            NucleusLogger.QUERY.warn(LOCALISER.msg("037003", this.value));
                            bExpr = new BooleanLiteral(this.qs, this.mapping, false).eq(new BooleanLiteral(this.qs, this.mapping, true));
                        }
                    }
                } else {
                    for (int i = 0; i < expr.expressionList.size(); ++i) {
                        ScalarExpression source = expr.expressionList.getExpression(i);
                        OID objectId = (OID)api.getIdForObject(this.value);
                        if (objectId == null) {
                            NucleusLogger.QUERY.warn(LOCALISER.msg("037003", this.value));
                            bExpr = new BooleanLiteral(this.qs, this.mapping, false).eq(new BooleanLiteral(this.qs, this.mapping, true));
                            continue;
                        }
                        JavaTypeMapping m = storeMgr.getMappingManager().getMappingWithDatastoreMapping(objectId.getKeyValue().getClass(), false, false, clr);
                        ScalarExpression oidExpr = m.newLiteral(this.qs, objectId.getKeyValue());
                        bExpr = source.eq(oidExpr);
                    }
                }
                if (expr.conditionExpr != null) {
                    bExpr = new BooleanExpression(expr.conditionExpr, OP_AND, bExpr);
                }
            }
        }
        return bExpr;
    }

    private int populatePrimaryKeyMappingsValuesForPCMapping(JavaTypeMapping[] pkMappings, Object[] pkFieldValues, int position, PersistenceCapableMapping pcMapping, AbstractClassMetaData cmd, AbstractMemberMetaData mmd, Object fieldValue, MappedStoreManager storeMgr, ClassLoaderResolver clr) {
        JavaTypeMapping[] subMappings = pcMapping.getJavaTypeMapping();
        if (subMappings.length == 0) {
            DatastoreClass table = storeMgr.getDatastoreClass(cmd.getFullClassName(), clr);
            JavaTypeMapping ownerMapping = table.getMemberMapping(mmd);
            EmbeddedMapping embMapping = (EmbeddedMapping)ownerMapping;
            for (int k = 0; k < embMapping.getNumberOfJavaTypeMappings(); ++k) {
                JavaTypeMapping subMapping;
                pkMappings[position] = subMapping = embMapping.getJavaTypeMapping(k);
                pkFieldValues[position] = this.getFieldValue(subMapping.getMemberMetaData(), fieldValue);
                ++position;
            }
        } else {
            AbstractClassMetaData pcCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(pcMapping.getType(), clr);
            int[] pcPkPositions = pcCmd.getPKMemberPositions();
            for (int k = 0; k < subMappings.length; ++k) {
                Object val;
                AbstractMemberMetaData pcMmd = pcCmd.getMetaDataForManagedMemberAtAbsolutePosition(pcPkPositions[k]);
                if (subMappings[k] instanceof PersistenceCapableMapping) {
                    val = this.getFieldValue(pcMmd, fieldValue);
                    position = this.populatePrimaryKeyMappingsValuesForPCMapping(pkMappings, pkFieldValues, position, (PersistenceCapableMapping)subMappings[k], pcCmd, pcMmd, val, storeMgr, clr);
                    continue;
                }
                val = this.getFieldValue(pcMmd, fieldValue);
                pkMappings[position] = subMappings[k];
                pkFieldValues[position] = val;
                ++position;
            }
        }
        return position;
    }

    private BooleanExpression eqApplicationIdentity(Object id, BooleanExpression bExpr, ScalarExpression expr, Index index, MappedStoreManager storeMgr, ClassLoaderResolver clr, AbstractClassMetaData acmd) {
        if (index == null) {
            index = new Index();
        }
        String[] pkFieldNames = acmd.getPrimaryKeyMemberNames();
        for (int i = 0; i < pkFieldNames.length; ++i) {
            Object value = ClassUtils.getValueOfFieldByReflection(id, pkFieldNames[i]);
            String pcClassName = storeMgr.getClassNameForObjectID(value, clr, null);
            if (pcClassName != null) {
                AbstractClassMetaData scmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(pcClassName, clr);
                if (bExpr == null) {
                    bExpr = this.eqApplicationIdentity(value, bExpr, expr, index, storeMgr, clr, scmd);
                    continue;
                }
                bExpr = bExpr.and(this.eqApplicationIdentity(value, bExpr, expr, index, storeMgr, clr, scmd));
                continue;
            }
            ScalarExpression source = expr.getExpressionList().getExpression(index.index);
            JavaTypeMapping mapping = storeMgr.getMappingManager().getMappingWithDatastoreMapping(value.getClass(), false, false, clr);
            ScalarExpression target = mapping.newLiteral(this.qs, value);
            bExpr = bExpr == null ? source.eq(target) : bExpr.and(source.eq(target));
            if (target.getExpressionList().size() == 0) {
                ++index.index;
                continue;
            }
            index.index += target.getExpressionList().size();
        }
        return bExpr;
    }

    public ScalarExpression accessField(String subfieldName, boolean innerJoin) {
        Object fieldValue = null;
        try {
            AbstractClassMetaData acmd = this.qs.getStoreManager().getOMFContext().getMetaDataManager().getMetaDataForClass(this.mappingClass, this.qs.getClassLoaderResolver());
            if (acmd == null) {
                fieldValue = ClassUtils.getValueOfFieldByReflection(this.value, subfieldName);
            } else {
                AbstractMemberMetaData fmd = acmd.getMetaDataForMember(subfieldName);
                if (fmd == null) {
                    throw new NucleusUserException("Cannot access field " + subfieldName + " on type " + this.mappingClass);
                }
                fieldValue = this.getFieldValue(fmd, this.value);
            }
        }
        catch (Exception e) {
            fieldValue = ClassUtils.getValueOfFieldByReflection(this.value, subfieldName);
        }
        try {
            if (fieldValue == null) {
                return new NullLiteral(this.qs);
            }
            JavaTypeMapping mapping = this.mappingClass != null && subfieldName == null ? this.qs.getStoreManager().getMappingManager().getMappingWithDatastoreMapping(this.qs.getClassLoaderResolver().classForName(this.mappingClass), false, false, this.qs.getClassLoaderResolver()) : this.qs.getStoreManager().getMappingManager().getMappingWithDatastoreMapping(fieldValue.getClass(), false, false, this.qs.getClassLoaderResolver());
            return mapping.newLiteral(this.qs, fieldValue);
        }
        catch (SecurityException e) {
            throw new NucleusUserException("Cannot access field: " + subfieldName, e);
        }
        catch (IllegalArgumentException e) {
            throw new NucleusUserException("Cannot access field: " + subfieldName, e);
        }
        catch (Exception e) {
            throw new NucleusUserException("Cannot access field: " + subfieldName + " " + e, e);
        }
    }

    public String toString() {
        return super.toString() + " = " + this.value.toString();
    }

    private Object getFieldValue(AbstractMemberMetaData fmd, Object object) {
        ObjectManager om = this.qs.getStoreManager().getApiAdapter().getObjectManager(object);
        if (om == null) {
            return ClassUtils.getValueOfFieldByReflection(object, fmd.getName());
        }
        StateManager sm = om.findStateManager(object);
        SingleValueFieldManager fm = new SingleValueFieldManager();
        if (!fmd.isPrimaryKey()) {
            om.getApiAdapter().isLoaded(sm, fmd.getAbsoluteFieldNumber());
        }
        sm.provideFields(new int[]{fmd.getAbsoluteFieldNumber()}, fm);
        return fm.fetchObjectField(fmd.getAbsoluteFieldNumber());
    }

    public void setRawValue(Object val) {
        this.rawValue = val;
    }

    public Object getRawValue() {
        return this.rawValue;
    }

    private static class Index {
        int index;

        private Index() {
        }
    }
}

