/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.taskqueue;

import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import com.google.appengine.repackaged.com.google.io.protocol.MessageAppender;
import com.google.appengine.repackaged.com.google.io.protocol.Proto2ParserAdapter;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSink;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSource;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import com.google.appengine.repackaged.com.google.io.protocol.UninterpretedTags;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import java.nio.charset.Charset;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction
extends ProtocolMessage<Transaction> {
    private static final long serialVersionUID = 1L;
    private long handle_ = 0L;
    private byte[] app_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
    private boolean mark_changes_ = false;
    private UninterpretedTags uninterpreted;
    private int optional_0_;
    public static final Transaction IMMUTABLE_DEFAULT_INSTANCE = new Transaction(){
        private static final long serialVersionUID = 1L;

        public Transaction clearHandle() {
            return this;
        }

        public Transaction setHandle(long x) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public Transaction clearApp() {
            return this;
        }

        public Transaction setAppAsBytes(byte[] x) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public Transaction setApp(String v) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public Transaction setApp(String v, Charset cs) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public Transaction clearMarkChanges() {
            return this;
        }

        public Transaction setMarkChanges(boolean x) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public Transaction mergeFrom(Transaction that) {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public boolean merge(ProtocolSource source) {
            ProtocolSupport.unsupportedOperation();
            return false;
        }

        public Transaction freeze() {
            return this;
        }

        public Transaction unfreeze() {
            ProtocolSupport.unsupportedOperation();
            return this;
        }

        public boolean isFrozen() {
            return true;
        }
    };
    public static final Parser<Transaction> PARSER = new Proto2ParserAdapter((ProtocolMessage)Transaction.getDefaultInstance());
    public static final int khandle = 1;
    public static final int kapp = 2;
    public static final int kmark_changes = 3;
    public static final String[] text = new String[4];
    public static final int[] types;
    public static final String style = "";
    public static final String style_content_type = "";

    public final long getHandle() {
        return this.handle_;
    }

    public final boolean hasHandle() {
        return (this.optional_0_ & 1) != 0;
    }

    public Transaction clearHandle() {
        this.optional_0_ &= 0xFFFFFFFE;
        this.handle_ = 0L;
        return this;
    }

    public Transaction setHandle(long x) {
        this.optional_0_ |= 1;
        this.handle_ = x;
        return this;
    }

    public final byte[] getAppAsBytes() {
        return this.app_;
    }

    public final boolean hasApp() {
        return (this.optional_0_ & 2) != 0;
    }

    public Transaction clearApp() {
        this.optional_0_ &= 0xFFFFFFFD;
        this.app_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        return this;
    }

    public Transaction setAppAsBytes(byte[] x) {
        this.optional_0_ |= 2;
        this.app_ = x;
        return this;
    }

    public final String getApp() {
        return ProtocolSupport.toStringUtf8((byte[])this.app_);
    }

    public Transaction setApp(String v) {
        if (v == null) {
            throw new NullPointerException();
        }
        this.optional_0_ |= 2;
        this.app_ = ProtocolSupport.toBytesUtf8((String)v);
        return this;
    }

    public final String getApp(Charset cs) {
        return ProtocolSupport.toString((byte[])this.app_, (Charset)cs);
    }

    public Transaction setApp(String v, Charset cs) {
        if (v == null) {
            throw new NullPointerException();
        }
        this.optional_0_ |= 2;
        this.app_ = ProtocolSupport.toBytes((String)v, (Charset)cs);
        return this;
    }

    public final boolean isMarkChanges() {
        return this.mark_changes_;
    }

    public final boolean hasMarkChanges() {
        return (this.optional_0_ & 4) != 0;
    }

    public Transaction clearMarkChanges() {
        this.optional_0_ &= 0xFFFFFFFB;
        this.mark_changes_ = false;
        return this;
    }

    public Transaction setMarkChanges(boolean x) {
        this.optional_0_ |= 4;
        this.mark_changes_ = x;
        return this;
    }

    public Transaction mergeFrom(Transaction that) {
        assert (that != this);
        int this_t0 = this.optional_0_;
        int that_t0 = that.optional_0_;
        if ((that_t0 & 1) != 0) {
            this_t0 |= 1;
            this.handle_ = that.handle_;
        }
        if ((that_t0 & 2) != 0) {
            this_t0 |= 2;
            this.app_ = that.app_;
        }
        if ((that_t0 & 4) != 0) {
            this_t0 |= 4;
            this.mark_changes_ = that.mark_changes_;
        }
        if (that.uninterpreted != null) {
            this.getUninterpretedForWrite().putAll((Multimap)that.uninterpreted);
        }
        this.optional_0_ = this_t0;
        return this;
    }

    public boolean equalsIgnoreUninterpreted(Transaction that) {
        return this.equals(that, true);
    }

    public boolean equals(Transaction that) {
        return this.equals(that, false);
    }

    public boolean equals(Transaction that, boolean ignoreUninterpreted) {
        if (that == null) {
            return false;
        }
        if (that == this) {
            return true;
        }
        int this_t0 = this.optional_0_;
        int that_t0 = that.optional_0_;
        if (this_t0 != that_t0) {
            return false;
        }
        if ((this_t0 & 1) != 0 && this.handle_ != that.handle_) {
            return false;
        }
        if ((this_t0 & 2) != 0 && !Arrays.equals(this.app_, that.app_)) {
            return false;
        }
        if ((this_t0 & 4) != 0 && this.mark_changes_ != that.mark_changes_) {
            return false;
        }
        return ignoreUninterpreted || UninterpretedTags.equivalent((UninterpretedTags)this.uninterpreted, (UninterpretedTags)that.uninterpreted);
    }

    public boolean equals(Object that) {
        return that instanceof Transaction && this.equals((Transaction)((Object)that));
    }

    public int hashCode() {
        int hash = 1975120663;
        int this_t0 = this.optional_0_;
        hash = hash * 31 + ((this_t0 & 1) != 0 ? ProtocolSupport.hashCode((long)this.handle_) : -113);
        hash = hash * 31 + ((this_t0 & 2) != 0 ? Arrays.hashCode(this.app_) : -113);
        hash = hash * 31 + ((this_t0 & 4) != 0 ? (this.mark_changes_ ? 1231 : 1237) : -113);
        if (this.uninterpreted != null && !this.uninterpreted.isEmpty()) {
            hash = hash * 31 + this.uninterpreted.hashCode();
        }
        return hash;
    }

    public boolean isInitialized() {
        int this_t0 = this.optional_0_;
        if ((this_t0 & 3) != 3) {
            if ((this_t0 & 1) == 0) {
                return false;
            }
            return false;
        }
        return true;
    }

    public int encodingSize() {
        int n = 10 + Protocol.stringSize((int)this.app_.length);
        int this_t0 = this.optional_0_;
        if ((this_t0 & 4) != 0) {
            n += 2;
        }
        return this.uninterpreted != null ? n + this.uninterpreted.encodingSize() : n;
    }

    public int maxEncodingSize() {
        int n = 17 + this.app_.length;
        return this.uninterpreted != null ? n + this.uninterpreted.maxEncodingSize() : n;
    }

    public MessageAppender getMessageAppender() {
        return this.getUninterpretedForWrite();
    }

    public void clear() {
        this.optional_0_ = 0;
        this.handle_ = 0L;
        this.app_ = ProtocolSupport.EMPTY_BYTE_ARRAY;
        this.mark_changes_ = false;
        this.uninterpreted = null;
    }

    public Transaction newInstance() {
        return new Transaction();
    }

    public ProtocolType getProtocolType() {
        return StaticHolder.protocolType;
    }

    public void outputTo(ProtocolSink sink) {
        sink.putByte((byte)9);
        sink.putLong(this.handle_);
        sink.putByte((byte)18);
        sink.putPrefixedData(this.app_);
        int this_t0 = this.optional_0_;
        if ((this_t0 & 4) != 0) {
            sink.putByte((byte)24);
            sink.putBoolean(this.mark_changes_);
        }
        if (this.uninterpreted != null) {
            this.uninterpreted.put(sink);
        }
    }

    public boolean merge(ProtocolSource source) {
        boolean result = true;
        int this_t0 = this.optional_0_;
        block6: while (source.hasRemaining()) {
            int tt = source.getVarInt();
            switch (tt) {
                case 0: {
                    result = false;
                    break block6;
                }
                case 9: {
                    this.handle_ = source.getLong();
                    this_t0 |= 1;
                    continue block6;
                }
                case 18: {
                    this.app_ = source.getPrefixedData();
                    this_t0 |= 2;
                    continue block6;
                }
                case 24: {
                    this.mark_changes_ = source.getBoolean();
                    this_t0 |= 4;
                    continue block6;
                }
                default: {
                    this.getUninterpretedForWrite().putBytes(Integer.valueOf(tt), source.getUninterpreted(tt));
                    continue block6;
                }
            }
        }
        this.optional_0_ = this_t0;
        return result;
    }

    public Transaction getDefaultInstanceForType() {
        return IMMUTABLE_DEFAULT_INSTANCE;
    }

    public static final Transaction getDefaultInstance() {
        return IMMUTABLE_DEFAULT_INSTANCE;
    }

    public Parser<Transaction> getParserForType() {
        return PARSER;
    }

    public Transaction freeze() {
        this.app_ = ProtocolSupport.freezeString((byte[])this.app_);
        return this;
    }

    public UninterpretedTags getUninterpretedForWrite() {
        if (this.uninterpreted == null) {
            this.uninterpreted = new UninterpretedTags();
        }
        return this.uninterpreted;
    }

    static {
        Transaction.text[0] = "ErrorCode";
        Transaction.text[1] = "handle";
        Transaction.text[2] = "app";
        Transaction.text[3] = "mark_changes";
        types = new int[4];
        Arrays.fill(types, 6);
        Transaction.types[0] = 0;
        Transaction.types[1] = 1;
        Transaction.types[2] = 2;
        Transaction.types[3] = 0;
    }

    private static class StaticHolder {
        private static final ProtocolType protocolType = ProtocolType.newProtocolType(Transaction.class, (String)"Z'apphosting/datastore/datastore_v3.proto\n#apphosting_datastore_v3.Transaction\u0013\u001a\u0006handle \u0001(\u00010\u00068\u0002\u0014\u0013\u001a\u0003app \u0002(\u00020\t8\u0002\u0014\u0013\u001a\fmark_changes \u0003(\u00000\b8\u0001B\u0005false\u00a3\u0001\u00aa\u0001\u0007default\u00b2\u0001\u0005false\u00a4\u0001\u0014", (ProtocolType.FieldType[])new ProtocolType.FieldType[]{new ProtocolType.FieldType("handle", "handle", 1, 0, ProtocolType.FieldBaseType.FIXED64, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("app", "app", 2, 1, ProtocolType.FieldBaseType.STRING, ProtocolType.Presence.REQUIRED), new ProtocolType.FieldType("mark_changes", "mark_changes", 3, 2, ProtocolType.FieldBaseType.BOOL, ProtocolType.Presence.OPTIONAL)});

        private StaticHolder() {
        }
    }
}

