/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.datasource.embedded;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.datasource.embedded.DataSourceFactory;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabase;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseConfigurer;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseConfigurerFactory;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.jdbc.datasource.embedded.SimpleDriverDataSourceFactory;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.util.Assert;

public class EmbeddedDatabaseFactory {
    private static Log logger = LogFactory.getLog(EmbeddedDatabaseFactory.class);
    private String databaseName = "testdb";
    private DataSourceFactory dataSourceFactory = new SimpleDriverDataSourceFactory();
    private EmbeddedDatabaseConfigurer databaseConfigurer;
    private DatabasePopulator databasePopulator;
    private DataSource dataSource;

    public void setDatabaseName(String databaseName) {
        Assert.notNull((Object)databaseName, (String)"Database name is required");
        this.databaseName = databaseName;
    }

    public void setDatabaseType(EmbeddedDatabaseType type) {
        this.databaseConfigurer = EmbeddedDatabaseConfigurerFactory.getConfigurer(type);
    }

    public void setDatabaseConfigurer(EmbeddedDatabaseConfigurer configurer) {
        Assert.notNull((Object)configurer, (String)"EmbeddedDatabaseConfigurer is required");
        this.databaseConfigurer = configurer;
    }

    public void setDatabasePopulator(DatabasePopulator populator) {
        Assert.notNull((Object)populator, (String)"DatabasePopulator is required");
        this.databasePopulator = populator;
    }

    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        Assert.notNull((Object)dataSourceFactory, (String)"DataSourceFactory is required");
        this.dataSourceFactory = dataSourceFactory;
    }

    public EmbeddedDatabase getDatabase() {
        if (this.dataSource == null) {
            this.initDatabase();
        }
        return new EmbeddedDataSourceProxy(this.dataSource);
    }

    protected void initDatabase() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Creating embedded database '" + this.databaseName + "'"));
        }
        if (this.databaseConfigurer == null) {
            this.databaseConfigurer = EmbeddedDatabaseConfigurerFactory.getConfigurer(EmbeddedDatabaseType.HSQL);
        }
        this.databaseConfigurer.configureConnectionProperties(this.dataSourceFactory.getConnectionProperties(), this.databaseName);
        this.dataSource = this.dataSourceFactory.getDataSource();
        if (this.databasePopulator != null) {
            this.populateDatabase();
        }
    }

    private void populateDatabase() {
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                this.databasePopulator.populate(connection);
            }
            catch (Throwable throwable) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
                throw throwable;
            }
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
        }
        catch (SQLException ex) {
            throw new DataAccessResourceFailureException("Failed to populate database", (Throwable)ex);
        }
    }

    protected DataSource getDataSource() {
        return this.dataSource;
    }

    protected void shutdownDatabase() {
        if (this.dataSource != null) {
            this.databaseConfigurer.shutdown(this.dataSource, this.databaseName);
            this.dataSource = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EmbeddedDataSourceProxy
    implements EmbeddedDatabase {
        private final DataSource dataSource;

        public EmbeddedDataSourceProxy(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.dataSource.getConnection();
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.dataSource.getConnection(username, password);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.dataSource.getLoginTimeout();
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.dataSource.getLogWriter();
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.dataSource.setLoginTimeout(seconds);
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.dataSource.setLogWriter(out);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.dataSource.isWrapperFor(iface);
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.dataSource.unwrap(iface);
        }

        @Override
        public void shutdown() {
            EmbeddedDatabaseFactory.this.shutdownDatabase();
        }
    }
}

