/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition.date.jodatime;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.springmodules.validation.util.condition.date.jodatime.AbstractInstantCondition;

public class IsBeforeInstantCondition
extends AbstractInstantCondition {
    private ReadableInstant later;

    public IsBeforeInstantCondition(ReadableInstant later) {
        this.later = later;
    }

    public IsBeforeInstantCondition(Date later) {
        this.later = new DateTime(later.getTime());
    }

    public IsBeforeInstantCondition(Calendar later) {
        this.later = new DateTime(later.getTimeInMillis(), DateTimeZone.forTimeZone((TimeZone)later.getTimeZone()));
    }

    protected boolean checkInstant(ReadableInstant instant) {
        return this.later.isAfter(instant);
    }

    public ReadableInstant getLater() {
        return this.later;
    }
}

