package com.jispot.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import net.sf.json.JSONSerializer;

public class JISpotAjaxController {

    private final Logger log = Logger.getLogger(this.getClass().getName());

    protected HttpSession session;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
            
    public void init(HttpServletRequest request, HttpServletResponse response) {
        this.session = request.getSession(true);
        this.request = request;
        this.response = response;
    }
    
    /**
     * Sends the jsonResult to the front
     */
    protected Long getUserId() {
        return (Long) session.getAttribute("USER_LOGIN");
    }
    
    /**
     * Sends the jsonResult to the front
     */
    protected void sendJsonResult(Object object) {
        if (object == null) {
            object = "";
        }
        PrintWriter out;
        try {
            String jsonOut = JSONSerializer.toJSON(object).toString();
            log.finest("JSon output :\n" + jsonOut);

            out = response.getWriter();
            response.setContentType("text/xml");
            response.setHeader("Cache-Control", "no-cache");
            out.write(jsonOut);
            out.flush();
        } 
        catch (IOException e) {
            // fall into timeout... ?
            // send back an error ? How ?
            e.printStackTrace();
            log.severe(e.getMessage());
        }
    }

}
        
        