/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.loader.annotation.handler;

import java.lang.annotation.Annotation;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.validation.Validator;
import org.springmodules.validation.bean.conf.MutableBeanValidationConfiguration;
import org.springmodules.validation.bean.conf.loader.annotation.handler.ClassValidationAnnotationHandler;
import org.springmodules.validation.bean.conf.loader.annotation.handler.ValidatorRef;

public class ValidatorReferenceClassValidationAnnotationHandler
implements ClassValidationAnnotationHandler,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public boolean supports(Annotation annotation, Class clazz) {
        return ValidatorRef.class.isInstance(annotation);
    }

    public void handleAnnotation(Annotation annotation, Class clazz, MutableBeanValidationConfiguration configuration) {
        ValidatorRef validator = (ValidatorRef)annotation;
        configuration.setCustomValidator(this.getSpringValidatorBean(validator.value()));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected Validator getSpringValidatorBean(String beanName) {
        if (this.applicationContext == null) {
            throw new UnsupportedOperationException("This handler can only work when deployed within spring application context");
        }
        return (Validator)this.applicationContext.getBean(beanName, Validator.class);
    }
}

