package com.jispot.web.spot;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import com.jispot.web.JISpotAjaxController;
import com.jispot.web.vo.CoordinateVO;

@Controller("mapSpotController")
public class MapSpotController extends JISpotAjaxController {

    protected final Logger log = Logger.getLogger(this.getClass().getName());
    
    /**
     * Retourne un marqueur sur la position courante du spotter.
     */
    @RequestMapping(value = "/jispot/spotters.html", method = RequestMethod.POST)
    public void spotters(HttpServletRequest request, HttpServletResponse response) {

        super.init(request, response);

        log.info("MapSpotController.spotters called!");

        // Get the data
        List<CoordinateVO> coords = new ArrayList<CoordinateVO>();
        coords.add(new CoordinateVO("43.566296", "-1.464761", "Julio", request.getContextPath() +"/static/img/gmaps/nursery.png"));
        coords.add(new CoordinateVO("43.662799", "-1.441036", "Ibi", request.getContextPath() +"/static/img/gmaps/bar.png"));

        super.sendJsonResult(coords);
    }

    /**
     * Retourne un marqueur sur la position courante du spotter.
     */
    @RequestMapping(value = "/jispot/spotplan.html", method = RequestMethod.POST)
    public void spotplan(HttpServletRequest request, HttpServletResponse response) {

        super.init(request, response);

        log.info("MapSpotController.spotplan called!");

        // Get the data
        List<CoordinateVO> coords = new ArrayList<CoordinateVO>();
        coords.add(new CoordinateVO("43.662799", "-1.441036", "Ibi's home", request.getContextPath() +"/static/img/gmaps/bar.png"));
        coords.add(new CoordinateVO("43.566296", "-1.464761", "Julio' home", request.getContextPath() +"/static/img/gmaps/nursery.png"));

        super.sendJsonResult(coords);
    }

}
