package com.jispot.domain.model;

import siena.*;
import static siena.Json.*;

@Table("spot")
public class Spot extends Model {

	@Id(Generator.AUTO_INCREMENT)
	public Long id;

    @Column("name")
    @Max(200)
    @NotNull
    public String name;
    
    @Column("description")
    @Text
    public String description;
    
    @Column("coordinate")
    @Index("coordinate_index")
    public Coordinate coordinate;

    @Column("address")
    @Index("address_index")
    public Address address;

    public static Query<Spot> all() {
		return Model.all(Spot.class);
	}

}
