/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.valang.javascript.taglib;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.validation.Validator;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.mvc.BaseCommandController;
import org.springmodules.validation.valang.ValangValidator;
import org.springmodules.validation.valang.javascript.taglib.ValangJavaScriptTagUtils;

public class ValangRulesExportInterceptor
extends HandlerInterceptorAdapter {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springmodules$validation$valang$javascript$taglib$ValangRulesExportInterceptor == null ? (class$org$springmodules$validation$valang$javascript$taglib$ValangRulesExportInterceptor = ValangRulesExportInterceptor.class$("org.springmodules.validation.valang.javascript.taglib.ValangRulesExportInterceptor")) : class$org$springmodules$validation$valang$javascript$taglib$ValangRulesExportInterceptor));
    static /* synthetic */ Class class$org$springmodules$validation$valang$javascript$taglib$ValangRulesExportInterceptor;
    static /* synthetic */ Class class$org$springmodules$validation$valang$ValangValidator;
    static /* synthetic */ Class class$org$springframework$web$servlet$mvc$BaseCommandController;

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        BaseCommandController controller = this.retrieveBaseCommandControllerIfPossible(handler);
        if (controller == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Controller is of type " + controller.getClass() + " so ignoring"));
            }
            return;
        }
        Map model = modelAndView.getModel();
        String commandName = controller.getCommandName();
        if (model == null || !model.containsKey(commandName)) {
            if (logger.isWarnEnabled()) {
                logger.debug((Object)("Handler '" + handler + "' did not export command object '" + controller.getCommandName() + "'; no rules added to model"));
            }
            return;
        }
        Validator[] validators = controller.getValidators();
        for (int i = 0; i < validators.length; ++i) {
            if (!(class$org$springmodules$validation$valang$ValangValidator == null ? ValangRulesExportInterceptor.class$("org.springmodules.validation.valang.ValangValidator") : class$org$springmodules$validation$valang$ValangValidator).isInstance(validators[i])) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding Valang rules from handler '" + handler + "' to model"));
            }
            ValangValidator validator = (ValangValidator)validators[i];
            ValangJavaScriptTagUtils.addValangRulesToModel(commandName, validator, model);
        }
    }

    private BaseCommandController retrieveBaseCommandControllerIfPossible(Object handler) throws Exception {
        BaseCommandController baseCommandController = null;
        if ((class$org$springframework$web$servlet$mvc$BaseCommandController == null ? (class$org$springframework$web$servlet$mvc$BaseCommandController = ValangRulesExportInterceptor.class$("org.springframework.web.servlet.mvc.BaseCommandController")) : class$org$springframework$web$servlet$mvc$BaseCommandController).isAssignableFrom(handler.getClass())) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"handler is type compatible, simply cast");
            }
            baseCommandController = (BaseCommandController)handler;
        } else if (AopUtils.isAopProxy((Object)handler)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"handler is AOP proxy");
            }
            Advised advisedObject = (Advised)handler;
            Class proxiedClass = advisedObject.getTargetClass();
            Object target = advisedObject.getTargetSource().getTarget();
            baseCommandController = this.retrieveBaseCommandControllerIfPossible(target);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Cannot convert handler to BaseCommandController");
        }
        return baseCommandController;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

