/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.core.OrderComparator;
import org.springframework.core.Ordered;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.util.UrlPathHelper;
import org.springframework.web.util.WebUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentNegotiatingViewResolver
extends WebApplicationObjectSupport
implements ViewResolver,
Ordered {
    private static final String ACCEPT_HEADER = "Accept";
    private static final boolean jafPresent = ClassUtils.isPresent((String)"javax.activation.FileTypeMap", (ClassLoader)ContentNegotiatingViewResolver.class.getClassLoader());
    private static final UrlPathHelper urlPathHelper = new UrlPathHelper();
    private int order = Integer.MIN_VALUE;
    private boolean favorPathExtension = true;
    private boolean favorParameter = false;
    private String parameterName = "format";
    private boolean ignoreAcceptHeader = false;
    private ConcurrentMap<String, MediaType> mediaTypes = new ConcurrentHashMap<String, MediaType>();
    private List<View> defaultViews;
    private MediaType defaultContentType;
    private List<ViewResolver> viewResolvers;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setFavorPathExtension(boolean favorPathExtension) {
        this.favorPathExtension = favorPathExtension;
    }

    public void setFavorParameter(boolean favorParameter) {
        this.favorParameter = favorParameter;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public void setIgnoreAcceptHeader(boolean ignoreAcceptHeader) {
        this.ignoreAcceptHeader = ignoreAcceptHeader;
    }

    public void setMediaTypes(Map<String, String> mediaTypes) {
        Assert.notNull(mediaTypes, (String)"'mediaTypes' must not be null");
        for (Map.Entry<String, String> entry : mediaTypes.entrySet()) {
            String extension = entry.getKey().toLowerCase(Locale.ENGLISH);
            MediaType mediaType = MediaType.parseMediaType((String)entry.getValue());
            this.mediaTypes.put(extension, mediaType);
        }
    }

    public void setDefaultViews(List<View> defaultViews) {
        this.defaultViews = defaultViews;
    }

    public void setDefaultContentType(MediaType defaultContentType) {
        this.defaultContentType = defaultContentType;
    }

    public void setViewResolvers(List<ViewResolver> viewResolvers) {
        this.viewResolvers = viewResolvers;
    }

    protected void initServletContext(ServletContext servletContext) {
        if (this.viewResolvers == null) {
            Map matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getApplicationContext(), ViewResolver.class);
            this.viewResolvers = new ArrayList<ViewResolver>(matchingBeans.size());
            for (ViewResolver viewResolver : matchingBeans.values()) {
                if (this == viewResolver) continue;
                this.viewResolvers.add(viewResolver);
            }
        }
        if (this.viewResolvers.isEmpty()) {
            this.logger.warn((Object)"Did not find any ViewResolvers to delegate to; please configure them using the 'viewResolvers' property on the ContentNegotiatingViewResolver");
        }
        OrderComparator.sort(this.viewResolvers);
    }

    protected List<MediaType> getMediaTypes(HttpServletRequest request) {
        String acceptHeader;
        String parameterValue;
        MediaType mediaType;
        String requestUri;
        String filename;
        MediaType mediaType2;
        if (this.favorPathExtension && (mediaType2 = this.getMediaTypeFromFilename(filename = WebUtils.extractFullFilenameFromUrlPath((String)(requestUri = urlPathHelper.getRequestUri(request))))) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Requested media type is '" + mediaType2 + "' (based on filename '" + filename + "')"));
            }
            ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
            mediaTypes.add(mediaType2);
            return mediaTypes;
        }
        if (this.favorParameter && request.getParameter(this.parameterName) != null && (mediaType = this.getMediaTypeFromParameter(parameterValue = request.getParameter(this.parameterName))) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Requested media type is '" + mediaType + "' (based on parameter '" + this.parameterName + "'='" + parameterValue + "')"));
            }
            ArrayList<MediaType> mediaTypes = new ArrayList<MediaType>();
            mediaTypes.add(mediaType);
            return mediaTypes;
        }
        if (!this.ignoreAcceptHeader && StringUtils.hasText((String)(acceptHeader = request.getHeader(ACCEPT_HEADER)))) {
            List mediaTypes = MediaType.parseMediaTypes((String)acceptHeader);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Requested media types are " + mediaTypes + " (based on Accept header)"));
            }
            return mediaTypes;
        }
        if (this.defaultContentType != null) {
            return Collections.singletonList(this.defaultContentType);
        }
        return Collections.emptyList();
    }

    protected MediaType getMediaTypeFromFilename(String filename) {
        String extension = StringUtils.getFilenameExtension((String)filename);
        if (!StringUtils.hasText((String)extension)) {
            return null;
        }
        MediaType mediaType = (MediaType)this.mediaTypes.get(extension = extension.toLowerCase(Locale.ENGLISH));
        if (mediaType == null && jafPresent && (mediaType = ActivationMediaTypeFactory.getMediaType(filename)) != null) {
            this.mediaTypes.putIfAbsent(extension, mediaType);
        }
        return mediaType;
    }

    protected MediaType getMediaTypeFromParameter(String parameterValue) {
        return (MediaType)this.mediaTypes.get(parameterValue.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public View resolveViewName(String viewName, Locale locale) throws Exception {
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        Assert.isInstanceOf(ServletRequestAttributes.class, (Object)attrs);
        ServletRequestAttributes servletAttrs = (ServletRequestAttributes)attrs;
        List<MediaType> requestedMediaTypes = this.getMediaTypes(servletAttrs.getRequest());
        if (requestedMediaTypes.size() > 1) {
            Collections.sort(requestedMediaTypes);
        }
        TreeMap<MediaType, View> views = new TreeMap<MediaType, View>();
        ArrayList<View> candidateViews = new ArrayList<View>();
        for (ViewResolver viewResolver : this.viewResolvers) {
            View view = viewResolver.resolveViewName(viewName, locale);
            if (view == null) continue;
            candidateViews.add(view);
        }
        if (!CollectionUtils.isEmpty(this.defaultViews)) {
            candidateViews.addAll(this.defaultViews);
        }
        block1: for (View candidateView : candidateViews) {
            String contentType = candidateView.getContentType();
            if (!StringUtils.hasText((String)contentType)) continue;
            MediaType viewMediaType = MediaType.parseMediaType((String)contentType);
            for (MediaType requestedMediaType : requestedMediaTypes) {
                if (!requestedMediaType.includes(viewMediaType) || views.containsKey(requestedMediaType)) continue;
                views.put(requestedMediaType, candidateView);
                continue block1;
            }
        }
        if (!views.isEmpty()) {
            MediaType mediaType = (MediaType)views.firstKey();
            View view = (View)views.get(mediaType);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Returning [" + view + "] based on requested media type '" + mediaType + "'"));
            }
            return view;
        }
        return null;
    }

    private static class ActivationMediaTypeFactory {
        private static final FileTypeMap fileTypeMap = ActivationMediaTypeFactory.loadFileTypeMapFromContextSupportModule();

        private ActivationMediaTypeFactory() {
        }

        /*
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static FileTypeMap loadFileTypeMapFromContextSupportModule() {
            ClassPathResource mappingLocation = new ClassPathResource("org/springframework/mail/javamail/mime.types");
            if (!mappingLocation.exists()) return FileTypeMap.getDefaultFileTypeMap();
            InputStream inputStream = null;
            inputStream = mappingLocation.getInputStream();
            MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap(inputStream);
            if (inputStream == null) return mimetypesFileTypeMap;
            try {
                inputStream.close();
                return mimetypesFileTypeMap;
            }
            catch (IOException iOException) {}
            return mimetypesFileTypeMap;
            catch (IOException iOException) {
                try {
                    if (inputStream == null) return FileTypeMap.getDefaultFileTypeMap();
                }
                catch (Throwable throwable) {
                    if (inputStream == null) throw throwable;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    inputStream.close();
                    return FileTypeMap.getDefaultFileTypeMap();
                }
                catch (IOException iOException3) {}
                return FileTypeMap.getDefaultFileTypeMap();
            }
        }

        public static MediaType getMediaType(String fileName) {
            String mediaType = fileTypeMap.getContentType(fileName);
            return StringUtils.hasText((String)mediaType) ? MediaType.parseMediaType((String)mediaType) : null;
        }
    }
}

