/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.util.condition.string;

import org.springframework.util.Assert;
import org.springmodules.validation.util.condition.string.AbstractStringCondition;

public class MinLengthStringCondition
extends AbstractStringCondition {
    private int minLength;

    public MinLengthStringCondition(int minLength) {
        Assert.isTrue((minLength >= 0 ? 1 : 0) != 0, (String)"Given minimum length must be a non-negative value");
        this.minLength = minLength;
    }

    protected boolean checkString(String text) {
        return text.length() >= this.minLength;
    }

    public int getMinLength() {
        return this.minLength;
    }
}

