/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.sql.jdbc.internal.ClientSideBlob;
import com.google.cloud.sql.jdbc.internal.ClientSideClob;
import com.google.cloud.sql.jdbc.internal.ClientSideNClob;
import com.google.cloud.sql.jdbc.internal.DataTypeConverter;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.cloud.sql.jdbc.internal.Util;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataTypeConverters {
    private static final Logger log = Logger.getLogger(DataTypeConverters.class.getName());
    private static final int FIRST_LOB_CHARACTER_POSITION = 1;
    private static final Map<Class<?>, DataTypeConverter<?>> CONVERTERS = DataTypeConverters.createConverters();

    private static Map<Class<?>, DataTypeConverter<?>> createConverters() {
        HashMap<Class<SQLXML>, DataTypeConverter<BigDecimal>> builder = Util.newHashMap();
        builder.put(BigDecimal.class, new BigDecimalConverter());
        builder.put(Boolean.class, new BooleanConverter());
        builder.put(Byte.class, new ByteConverter());
        builder.put(Date.class, new DateConverter());
        builder.put(Double.class, new DoubleConverter());
        builder.put(Float.class, new FloatConverter());
        builder.put(Integer.class, new IntegerConverter());
        builder.put(Long.class, new LongConverter());
        builder.put(Short.class, new ShortConverter());
        builder.put(String.class, new StringConverter());
        builder.put(Time.class, new TimeConverter());
        builder.put(Timestamp.class, new TimestampConverter());
        builder.put(byte[].class, new ByteArrayConverter());
        builder.put(Blob.class, new BlobConverter());
        builder.put(Clob.class, new ClobConverter());
        builder.put(NClob.class, new NClobConverter());
        builder.put(char[].class, new UnsupportedConverter());
        builder.put(Object.class, new UnsupportedConverter());
        builder.put(Array.class, new UnsupportedConverter());
        builder.put(Struct.class, new UnsupportedConverter());
        builder.put(Ref.class, new UnsupportedConverter());
        builder.put(RowId.class, new UnsupportedConverter());
        builder.put(SQLXML.class, new UnsupportedConverter());
        return Collections.unmodifiableMap(builder);
    }

    public static <T> DataTypeConverter<T> getConverter(Class<T> clazz) {
        DataTypeConverter<?> converter = CONVERTERS.get(clazz);
        if (converter == null) {
            for (Map.Entry<Class<?>, DataTypeConverter<?>> e : CONVERTERS.entrySet()) {
                if (!e.getKey().isAssignableFrom(clazz) || e.getKey().equals(Object.class)) continue;
                DataTypeConverter<?> value = e.getValue();
                return value;
            }
        }
        return converter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnsupportedConverter<T>
    implements DataTypeConverter<T> {
        UnsupportedConverter() {
        }

        @Override
        public T toObject(ByteString value) {
            throw new UnsupportedOperationException("This converter is not implemented.");
        }

        @Override
        public ByteString toByteString(Object value) {
            throw new UnsupportedOperationException("This converter is not implemented for type " + (value != null ? value.getClass().getName() : "(unknown class)"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TimestampConverter
    extends ToByteStringConverter<Timestamp> {
        TimestampConverter() {
        }

        @Override
        public Timestamp toObject(ByteString value) throws SQLException {
            if (value == null) {
                return null;
            }
            String s = value.toStringUtf8();
            try {
                return Timestamp.valueOf(s);
            }
            catch (IllegalArgumentException outerException) {
                try {
                    return Timestamp.valueOf(String.format("%s 00:00:00", Date.valueOf(s)));
                }
                catch (IllegalArgumentException innerException) {
                    throw Exceptions.newSqlException("Invalid timestamp format", outerException);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TimeConverter
    extends ToByteStringConverter<Time> {
        TimeConverter() {
        }

        @Override
        public Time toObject(ByteString value) {
            return value != null ? Time.valueOf(value.toStringUtf8()) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringConverter
    extends ToByteStringConverter<String> {
        StringConverter() {
        }

        @Override
        public String toObject(ByteString value) {
            return value != null ? value.toStringUtf8() : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ShortConverter
    extends ToByteStringConverter<Short> {
        ShortConverter() {
        }

        @Override
        public Short toObject(ByteString value) {
            return value != null ? Short.valueOf(value.toStringUtf8()) : Short.valueOf((short)0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NClobConverter
    implements DataTypeConverter<NClob> {
        NClobConverter() {
        }

        @Override
        public NClob toObject(ByteString value) {
            if (value == null) {
                return null;
            }
            return new ClientSideNClob(value);
        }

        @Override
        public ByteString toByteString(Object value) throws SQLException {
            if (value == null) {
                return null;
            }
            if (!(value instanceof NClob)) {
                throw Exceptions.newSqlException("java.sql.NClob expected, got " + value.getClass().getCanonicalName());
            }
            if (value instanceof ClientSideNClob) {
                return ((ClientSideNClob)value).toByteString();
            }
            NClob nclob = (NClob)value;
            return ByteString.copyFromUtf8(nclob.getSubString(1L, (int)nclob.length()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LongConverter
    extends ToByteStringConverter<Long> {
        LongConverter() {
        }

        @Override
        public Long toObject(ByteString value) {
            return value != null ? Long.valueOf(value.toStringUtf8()) : Long.valueOf(0L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntegerConverter
    extends ToByteStringConverter<Integer> {
        IntegerConverter() {
        }

        @Override
        public Integer toObject(ByteString value) {
            return value != null ? Integer.valueOf(value.toStringUtf8()) : Integer.valueOf(0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FloatConverter
    extends ToByteStringConverter<Float> {
        FloatConverter() {
        }

        @Override
        public Float toObject(ByteString value) {
            return value != null ? Float.valueOf(value.toStringUtf8()) : Float.valueOf(0.0f);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DoubleConverter
    extends ToByteStringConverter<Double> {
        DoubleConverter() {
        }

        @Override
        public Double toObject(ByteString value) {
            return value != null ? Double.valueOf(value.toStringUtf8()) : Double.valueOf(0.0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DateConverter
    extends ToByteStringConverter<Date> {
        DateConverter() {
        }

        @Override
        public Date toObject(ByteString value) {
            if (value == null) {
                return null;
            }
            String dateString = value.toStringUtf8();
            if (dateString.indexOf(32) != -1) {
                return Date.valueOf(dateString.substring(0, dateString.indexOf(32)));
            }
            return Date.valueOf(dateString);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClobConverter
    implements DataTypeConverter<Clob> {
        ClobConverter() {
        }

        @Override
        public Clob toObject(ByteString value) {
            if (value == null) {
                return null;
            }
            return new ClientSideClob(value);
        }

        @Override
        public ByteString toByteString(Object value) throws SQLException {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Clob)) {
                throw Exceptions.newSqlException("java.sql.Clob expected, got " + value.getClass().getCanonicalName());
            }
            if (value instanceof ClientSideClob) {
                return ((ClientSideClob)value).toByteString();
            }
            Clob clob = (Clob)value;
            return ByteString.copyFromUtf8(clob.getSubString(1L, (int)clob.length()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByteArrayConverter
    implements DataTypeConverter<byte[]> {
        ByteArrayConverter() {
        }

        @Override
        public byte[] toObject(ByteString value) {
            if (value == null) {
                return null;
            }
            return value.toByteArray();
        }

        @Override
        public ByteString toByteString(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof byte[]) {
                return ByteString.copyFrom((byte[])value);
            }
            return ByteString.copyFromUtf8(value.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ByteConverter
    extends ToByteStringConverter<Byte> {
        ByteConverter() {
        }

        @Override
        public Byte toObject(ByteString value) {
            return value != null ? Byte.valueOf(value.toStringUtf8()) : null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BooleanConverter
    extends ToByteStringConverter<Boolean> {
        BooleanConverter() {
        }

        @Override
        public Boolean toObject(ByteString value) {
            if (value == null) {
                return null;
            }
            log.log(Level.FINE, "BooleanConverter: value={0}", value.toStringUtf8());
            if (value.size() == 1) {
                byte b = value.byteAt(0);
                if (b == 1 || b == 49) {
                    return true;
                }
                if (b == 0 || b == 48) {
                    return false;
                }
                log.log(Level.WARNING, "BooleanConverter: Unknown value: {0}", value.toStringUtf8());
            }
            return Boolean.valueOf(value.toStringUtf8());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BlobConverter
    implements DataTypeConverter<Blob> {
        BlobConverter() {
        }

        @Override
        public Blob toObject(ByteString value) {
            if (value == null) {
                return null;
            }
            return new ClientSideBlob(value);
        }

        @Override
        public ByteString toByteString(Object value) throws SQLException {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Blob)) {
                throw Exceptions.newSqlException("java.sql.Blob expected, got " + value.getClass().getCanonicalName());
            }
            Blob blob = (Blob)value;
            return ByteString.copyFrom(blob.getBytes(1L, (int)blob.length()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BigDecimalConverter
    implements DataTypeConverter<BigDecimal> {
        BigDecimalConverter() {
        }

        @Override
        public BigDecimal toObject(ByteString value) {
            if (value == null || value.size() == 0) {
                return null;
            }
            return new BigDecimal(value.toStringUtf8());
        }

        @Override
        public ByteString toByteString(Object value) throws SQLException {
            if (!(value instanceof BigDecimal)) {
                throw Exceptions.newSqlException("java.math.BigDecimal expected, got " + value.getClass().getCanonicalName());
            }
            return ByteString.copyFromUtf8(((BigDecimal)value).toPlainString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class ToByteStringConverter<T>
    implements DataTypeConverter<T> {
        ToByteStringConverter() {
        }

        @Override
        public ByteString toByteString(Object value) {
            if (value instanceof byte[]) {
                return ByteString.copyFrom((byte[])value);
            }
            if (value instanceof ByteString) {
                return (ByteString)value;
            }
            return value != null ? ByteString.copyFromUtf8(value.toString()) : null;
        }
    }
}

