/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;

public class CompositeIndexManager {
    private static final String DATASTORE_INDEX_WITH_PROPERTIES_XML_FORMAT = "    <datastore-index kind=\"%s\" ancestor=\"%s\" source=\"%s\">\n%s    </datastore-index>\n\n";
    private static final String DATASTORE_INDEX_NO_PROPERTIES_XML_FORMAT = "    <datastore-index kind=\"%s\" ancestor=\"%s\" source=\"%s\"/>\n\n";
    private static final String PROPERTY_XML_FORMAT = "        <property name=\"%s\" direction=\"%s\"/>\n";

    protected String generateXmlForIndex(OnestoreEntity.Index index, IndexSource source) {
        boolean isAncestor = index.isAncestor();
        if (index.propertySize() == 0) {
            return String.format(DATASTORE_INDEX_NO_PROPERTIES_XML_FORMAT, new Object[]{index.getEntityType(), isAncestor, source});
        }
        StringBuilder sb = new StringBuilder();
        for (OnestoreEntity.Index.Property prop : index.propertys()) {
            String dir = prop.getDirectionEnum() == OnestoreEntity.Index.Property.Direction.ASCENDING ? "asc" : "desc";
            sb.append(String.format(PROPERTY_XML_FORMAT, prop.getName(), dir));
        }
        return String.format(DATASTORE_INDEX_WITH_PROPERTIES_XML_FORMAT, new Object[]{index.getEntityType(), isAncestor, source, sb.toString()});
    }

    protected OnestoreEntity.Index compositeIndexForQuery(IndexComponentsOnlyQuery indexOnlyQuery) {
        DatastorePb.Query query = indexOnlyQuery.getQuery();
        boolean hasKind = query.hasKind();
        boolean hasAncestor = query.hasAncestor();
        List<DatastorePb.Query.Filter> filters = query.filters();
        List<DatastorePb.Query.Order> orders = query.orders();
        if (filters.isEmpty() && orders.isEmpty()) {
            return null;
        }
        List<String> eqProps = indexOnlyQuery.getEqualityProps();
        List<OnestoreEntity.Index.Property> indexProperties = indexOnlyQuery.getIndexProps();
        if (hasKind && !eqProps.isEmpty() && eqProps.size() == filters.size() && !indexOnlyQuery.hasKeyProperty() && orders.isEmpty()) {
            return null;
        }
        if (!(!hasKind || hasAncestor || indexProperties.size() > 1 || indexOnlyQuery.hasKeyProperty() && indexProperties.get(0).getDirectionEnum() != OnestoreEntity.Index.Property.Direction.ASCENDING)) {
            return null;
        }
        OnestoreEntity.Index index = new OnestoreEntity.Index();
        index.setEntityType(query.getKind());
        index.setAncestor(hasAncestor);
        index.mutablePropertys().addAll(indexProperties);
        return index;
    }

    protected static class KeyTranslator
    extends com.google.appengine.api.datastore.KeyTranslator {
        protected KeyTranslator() {
        }
    }

    protected static class ValidatedQuery
    extends com.google.appengine.api.datastore.ValidatedQuery {
        public ValidatedQuery(DatastorePb.Query query) {
            super(query);
        }
    }

    protected static class IndexComponentsOnlyQuery
    extends com.google.appengine.api.datastore.IndexComponentsOnlyQuery {
        public IndexComponentsOnlyQuery(DatastorePb.Query query) {
            super(query);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum IndexSource {
        auto,
        manual;

    }
}

