/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import java.lang.reflect.Array;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.mapped.expression.ArrayExpression;
import org.datanucleus.store.mapped.expression.Literal;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

public class ArrayLiteral
extends ArrayExpression
implements Literal {
    Object value;

    protected ArrayLiteral(QueryExpression qs) {
        super(qs);
    }

    public ArrayLiteral(QueryExpression qs, ScalarExpression[] expr) {
        super(qs);
        this.exprs = expr;
    }

    public ArrayLiteral(QueryExpression qs, JavaTypeMapping mapping, Object literal) {
        super(qs);
        this.mapping = mapping;
        this.value = literal;
        if (this.value == null || !this.value.getClass().isArray()) {
            throw new NucleusUserException("Invalid argument literal : " + this.value);
        }
        this.exprs = new ScalarExpression[Array.getLength(this.value)];
        for (int i = 0; i < Array.getLength(this.value); ++i) {
            JavaTypeMapping m = qs.getStoreManager().getMappingManager().getMappingWithDatastoreMapping(Array.get(this.value, i).getClass(), false, false, qs.getClassLoaderResolver());
            this.exprs[i] = m.newLiteral(qs, Array.get(this.value, i));
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setRawValue(Object val) {
    }

    public Object getRawValue() {
        return null;
    }
}

