/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.util;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.util.Imports;
import org.datanucleus.util.Localiser;

public class MacroString {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    private final String thisClassName;
    private final Imports imports;
    private final String macroString;

    public MacroString(String className, String importsString, String macroString) {
        this.thisClassName = className;
        this.macroString = macroString;
        this.imports = new Imports();
        if (this.thisClassName != null) {
            this.imports.importPackage(this.thisClassName);
        }
        if (importsString != null) {
            this.imports.parseImports(importsString);
        }
    }

    public String substituteMacros(MacroHandler mh, ClassLoaderResolver clr) {
        int right;
        int left;
        StringBuffer outBuf = new StringBuffer();
        int curr = 0;
        while (curr < this.macroString.length()) {
            left = this.macroString.indexOf(123, curr);
            if (left < 0) {
                outBuf.append(this.macroString.substring(curr));
                break;
            }
            outBuf.append(this.macroString.substring(curr, left));
            right = this.macroString.indexOf(125, left + 1);
            if (right < 0) {
                throw new NucleusUserException(LOCALISER.msg("031000", (Object)this.macroString));
            }
            IdentifierMacro im = this.parseIdentifierMacro(this.macroString.substring(left + 1, right), clr);
            mh.onIdentifierMacro(im);
            outBuf.append(im.value);
            curr = right + 1;
        }
        String tmpString = outBuf.toString();
        outBuf = new StringBuffer();
        int curr2 = 0;
        while (curr2 < tmpString.length()) {
            left = tmpString.indexOf(63, curr2);
            if (left < 0) {
                outBuf.append(tmpString.substring(curr2));
                break;
            }
            outBuf.append(tmpString.substring(curr2, left));
            right = tmpString.indexOf(63, left + 1);
            if (right < 0) {
                throw new NucleusUserException(LOCALISER.msg("031001", (Object)tmpString));
            }
            ParameterMacro pm = new ParameterMacro(tmpString.substring(left + 1, right));
            mh.onParameterMacro(pm);
            outBuf.append('?');
            curr2 = right + 1;
        }
        return outBuf.toString();
    }

    private Class resolveClassDeclaration(String className, ClassLoaderResolver clr) {
        try {
            return className.equals("this") ? clr.classForName(this.thisClassName, null) : this.imports.resolveClassDeclaration(className, clr, null);
        }
        catch (ClassNotResolvedException e) {
            return null;
        }
    }

    private IdentifierMacro parseIdentifierMacro(String unparsed, ClassLoaderResolver clr) {
        String className = null;
        String fieldName = null;
        String subfieldName = null;
        Class c = this.resolveClassDeclaration(unparsed, clr);
        if (c == null) {
            int lastDot = unparsed.lastIndexOf(46);
            if (lastDot < 0) {
                throw new NucleusUserException(LOCALISER.msg("031002", (Object)unparsed));
            }
            fieldName = unparsed.substring(lastDot + 1);
            className = unparsed.substring(0, lastDot);
            c = this.resolveClassDeclaration(className, clr);
            if (c == null) {
                int lastDot2 = unparsed.lastIndexOf(46, lastDot - 1);
                if (lastDot2 < 0) {
                    throw new NucleusUserException(LOCALISER.msg("031002", (Object)unparsed));
                }
                subfieldName = fieldName;
                fieldName = unparsed.substring(lastDot2 + 1, lastDot);
                className = unparsed.substring(0, lastDot2);
                c = this.resolveClassDeclaration(className, clr);
                if (c == null) {
                    throw new NucleusUserException(LOCALISER.msg("031002", (Object)unparsed));
                }
            }
        }
        return new IdentifierMacro(unparsed, c.getName(), fieldName, subfieldName);
    }

    public static interface MacroHandler {
        public void onIdentifierMacro(IdentifierMacro var1);

        public void onParameterMacro(ParameterMacro var1);
    }

    public static class ParameterMacro {
        public final String parameterName;

        ParameterMacro(String parameterName) {
            this.parameterName = parameterName;
        }

        public String toString() {
            return "?" + this.parameterName + "?";
        }
    }

    public static class IdentifierMacro {
        public final String unparsed;
        public final String className;
        public final String fieldName;
        public final String subfieldName;
        public String value;

        IdentifierMacro(String unparsed, String className, String fieldName, String subfieldName) {
            this.unparsed = unparsed;
            this.className = className;
            this.fieldName = fieldName;
            this.subfieldName = subfieldName;
            this.value = null;
        }

        public String toString() {
            return "{" + this.unparsed + "}";
        }
    }
}

