/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Text;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.api.ApiAdapter;
import org.datanucleus.exceptions.NoPersistenceInformationException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ColumnMetaData;
import org.datanucleus.metadata.EmbeddedMetaData;
import org.datanucleus.metadata.NullValue;
import org.datanucleus.state.StateManagerFactory;
import org.datanucleus.store.appengine.DatastoreManager;
import org.datanucleus.store.appengine.DatastoreRelationFieldManager;
import org.datanucleus.store.appengine.DatastoreTable;
import org.datanucleus.store.appengine.EntityUtils;
import org.datanucleus.store.appengine.FatalNucleusUserException;
import org.datanucleus.store.appengine.InsertMappingConsumer;
import org.datanucleus.store.appengine.KeyRegistry;
import org.datanucleus.store.appengine.SerializationManager;
import org.datanucleus.store.appengine.StorageVersion;
import org.datanucleus.store.appengine.TypeConversionUtils;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.jpa.DatastoreJPACallbackHandler;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.IdentifierFactory;
import org.datanucleus.store.mapped.mapping.EmbeddedMapping;
import org.datanucleus.store.mapped.mapping.IndexMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastoreFieldManager
implements FieldManager {
    private static final String ILLEGAL_NULL_ASSIGNMENT_ERROR_FORMAT = "Datastore entity with kind %s and key %s has a null property named %s.  This property is mapped to %s, which cannot accept null values.";
    private static final int[] NOT_USED = new int[]{0};
    private static final TypeConversionUtils TYPE_CONVERSION_UTILS = new TypeConversionUtils();
    private final LinkedList<FieldManagerState> fieldManagerStateStack = new LinkedList();
    private final boolean createdWithoutEntity;
    private final DatastoreManager storeManager;
    private final DatastoreRelationFieldManager relationFieldManager;
    private final SerializationManager serializationManager;
    private final Operation operation;
    private Entity datastoreEntity;
    private AbstractMemberMetaData parentMemberMetaData;
    private boolean parentAlreadySet = false;
    private boolean keyAlreadySet = false;
    private Integer pkIdPos = null;
    private boolean repersistingForChildKeys = false;
    private static final String PARENT_ALREADY_SET = "Cannot set both the primary key and a parent pk field.  If you want the datastore to generate an id for you, set the parent pk field to be the value of your parent key and leave the primary key field blank.  If you wish to provide a named key, leave the parent pk field blank and set the primary key to be a Key object made up of both the parent key and the named child.";
    private static final Set<Integer> PARENT_RELATION_TYPES = Collections.synchronizedSet(Utils.newHashSet(4, 3, 2, 1));
    private static final Field PROPERTY_MAP_FIELD;

    private DatastoreFieldManager(StateManager sm, boolean createdWithoutEntity, DatastoreManager storeManager, Entity datastoreEntity, int[] fieldNumbers, Operation operation) {
        AbstractMemberMetaDataProvider ammdProvider = new AbstractMemberMetaDataProvider(){

            public AbstractMemberMetaData get(int fieldNumber) {
                return DatastoreFieldManager.this.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
            }
        };
        this.createdWithoutEntity = createdWithoutEntity;
        this.storeManager = storeManager;
        this.datastoreEntity = datastoreEntity;
        InsertMappingConsumer mappingConsumer = this.buildMappingConsumer(sm.getClassMetaData(), sm.getObjectManager().getClassLoaderResolver(), fieldNumbers);
        this.fieldManagerStateStack.addFirst(new FieldManagerState(sm, ammdProvider, mappingConsumer, false));
        this.relationFieldManager = new DatastoreRelationFieldManager(this);
        this.serializationManager = new SerializationManager();
        this.operation = operation;
        String expectedKind = EntityUtils.determineKind(this.getClassMetaData(), sm.getObjectManager());
        if (!expectedKind.equals(datastoreEntity.getKind())) {
            throw new NucleusException("StateManager is for <" + expectedKind + "> but key is for <" + datastoreEntity.getKind() + ">.  One way this can happen is if you attempt to fetch an object of one type using" + " a Key of a different type.").setFatal();
        }
    }

    DatastoreFieldManager(StateManager stateManager, DatastoreManager storeManager, Entity datastoreEntity, int[] fieldNumbers, Operation operation) {
        this(stateManager, false, storeManager, datastoreEntity, fieldNumbers, operation);
    }

    public DatastoreFieldManager(StateManager stateManager, DatastoreManager storeManager, Entity datastoreEntity, Operation operation) {
        this(stateManager, false, storeManager, datastoreEntity, new int[0], operation);
    }

    DatastoreFieldManager(StateManager stateManager, String kind, DatastoreManager storeManager, Operation operation) {
        this(stateManager, true, storeManager, new Entity(kind), new int[0], operation);
    }

    public String fetchStringField(int fieldNumber) {
        if (this.isPK(fieldNumber)) {
            return this.fetchStringPKField(fieldNumber);
        }
        if (this.isParentPK(fieldNumber)) {
            return this.fetchParentStringPKField(fieldNumber);
        }
        if (this.isPKNameField(fieldNumber)) {
            if (!this.fieldIsOfTypeString(fieldNumber)) {
                throw new FatalNucleusUserException("Field with \"gae.pk-name\" extension must be of type String");
            }
            return this.fetchPKNameField();
        }
        Object fieldVal = this.fetchObjectField(fieldNumber);
        if (fieldVal instanceof Text) {
            fieldVal = ((Text)fieldVal).getValue();
        }
        return (String)fieldVal;
    }

    private String fetchPKNameField() {
        Key key = this.datastoreEntity.getKey();
        if (key.getName() == null) {
            throw new FatalNucleusUserException("Attempting to fetch field with \"gae.pk-name\" extension but the entity is identified by an id, not a name.");
        }
        return this.datastoreEntity.getKey().getName();
    }

    private long fetchPKIdField() {
        Key key = this.datastoreEntity.getKey();
        if (key.getName() != null) {
            throw new FatalNucleusUserException("Attempting to fetch field with \"gae.pk-id\" extension but the entity is identified by a name, not an id.");
        }
        return this.datastoreEntity.getKey().getId();
    }

    private String fetchParentStringPKField(int fieldNumber) {
        Key parentKey = this.datastoreEntity.getKey().getParent();
        if (parentKey == null) {
            return null;
        }
        return KeyFactory.keyToString((Key)parentKey);
    }

    private String fetchStringPKField(int fieldNumber) {
        if (DatastoreManager.isEncodedPKField(this.getClassMetaData(), fieldNumber)) {
            return KeyFactory.keyToString((Key)this.datastoreEntity.getKey());
        }
        if (this.datastoreEntity.getKey().isComplete() && this.datastoreEntity.getKey().getName() == null) {
            throw new FatalNucleusUserException("The primary key for " + this.getClassMetaData().getFullClassName() + " is an unencoded " + "string but the key of the corresponding entity in the datastore does not have a " + "name.  You may want to either change the primary key to be an encoded string " + "(add the \"" + "gae.encoded-pk" + "\" extension), change the " + "primary key to be of type " + Key.class.getName() + ", or, if you're certain that " + "this class will never have a parent, change the primary key to be of type Long.");
        }
        return this.datastoreEntity.getKey().getName();
    }

    public short fetchShortField(int fieldNumber) {
        return (Short)this.fetchObjectField(fieldNumber);
    }

    private boolean fieldIsOfTypeKey(int fieldNumber) {
        return this.getMetaData(fieldNumber).getType().equals(Key.class);
    }

    private boolean fieldIsOfTypeString(int fieldNumber) {
        return this.getMetaData(fieldNumber).getType().equals(String.class);
    }

    private boolean fieldIsOfTypeLong(int fieldNumber) {
        return this.getMetaData(fieldNumber).getType().equals(Long.class);
    }

    private RuntimeException exceptionForUnexpectedKeyType(String fieldType, int fieldNumber) {
        return new IllegalStateException(fieldType + " for type " + this.getClassMetaData().getName() + " is of unexpected type " + this.getMetaData(fieldNumber).getType().getName() + " (must be String, Long, or " + Key.class.getName() + ")");
    }

    public Object fetchObjectField(int fieldNumber) {
        AbstractMemberMetaData ammd = this.getMetaData(fieldNumber);
        if (ammd.getEmbeddedMetaData() != null) {
            return this.fetchEmbeddedField(ammd, fieldNumber);
        }
        if (ammd.getRelationType(this.getClassLoaderResolver()) != 0 && !ammd.isSerialized()) {
            return this.relationFieldManager.fetchRelationField(this.getClassLoaderResolver(), ammd);
        }
        if (this.isPK(fieldNumber)) {
            if (this.fieldIsOfTypeKey(fieldNumber)) {
                return this.datastoreEntity.getKey();
            }
            if (this.fieldIsOfTypeLong(fieldNumber)) {
                return this.datastoreEntity.getKey().getId();
            }
            throw this.exceptionForUnexpectedKeyType("Primary key", fieldNumber);
        }
        if (this.isParentPK(fieldNumber)) {
            if (this.fieldIsOfTypeKey(fieldNumber)) {
                return this.datastoreEntity.getKey().getParent();
            }
            throw this.exceptionForUnexpectedKeyType("Parent key", fieldNumber);
        }
        if (this.isPKIdField(fieldNumber)) {
            return this.fetchPKIdField();
        }
        Object value = this.datastoreEntity.getProperty(this.getPropertyName(fieldNumber));
        ClassLoaderResolver clr = this.getClassLoaderResolver();
        if (ammd.isSerialized()) {
            if (value != null) {
                value = this.deserializeFieldValue(value, clr, ammd);
            }
        } else {
            if (ammd.getAbsoluteFieldNumber() == -1) {
                ammd = this.getClassMetaData().getMetaDataForMember(ammd.getName());
            }
            if ((value = this.getConversionUtils().datastoreValueToPojoValue(clr, value, this.getStateManager(), ammd)) != null && Enum.class.isAssignableFrom(ammd.getType())) {
                Class enumClass = ammd.getType();
                value = Enum.valueOf(enumClass, (String)value);
            }
        }
        return value;
    }

    private Object deserializeFieldValue(Object value, ClassLoaderResolver clr, AbstractMemberMetaData ammd) {
        if (!(value instanceof Blob)) {
            throw new NucleusException("Datastore value is of type " + value.getClass().getName() + " (must be Blob).").setFatal();
        }
        return this.serializationManager.deserialize(clr, ammd, (Blob)value);
    }

    private AbstractMemberMetaDataProvider getEmbeddedAbstractMemberMetaDataProvider(final InsertMappingConsumer consumer) {
        return new AbstractMemberMetaDataProvider(){

            public AbstractMemberMetaData get(int fieldNumber) {
                return consumer.getMemberMetaDataForIndex(fieldNumber);
            }
        };
    }

    private StateManager getEmbeddedStateManager(AbstractMemberMetaData ammd, int fieldNumber, Object value) {
        ObjectManager objMgr;
        StateManager embeddedStateMgr;
        if (value == null) {
            value = JDOImplHelper.getInstance().newInstance(ammd.getType(), (javax.jdo.spi.StateManager)this.getStateManager());
        }
        if ((embeddedStateMgr = (objMgr = this.getObjectManager()).findStateManager(value)) == null) {
            embeddedStateMgr = StateManagerFactory.newStateManagerForEmbedded((ObjectManager)objMgr, (Object)value, (boolean)false);
            embeddedStateMgr.addEmbeddedOwner(this.getStateManager(), fieldNumber);
            embeddedStateMgr.setPcObjectType(1);
        }
        return embeddedStateMgr;
    }

    private Object fetchEmbeddedField(AbstractMemberMetaData ammd, int fieldNumber) {
        StateManager esm = this.getEmbeddedStateManager(ammd, fieldNumber, null);
        InsertMappingConsumer mappingConsumer = this.buildMappingConsumer(esm.getClassMetaData(), this.getClassLoaderResolver(), esm.getClassMetaData().getAllMemberPositions(), ammd.getEmbeddedMetaData());
        AbstractMemberMetaDataProvider ammdProvider = this.getEmbeddedAbstractMemberMetaDataProvider(mappingConsumer);
        this.fieldManagerStateStack.addFirst(new FieldManagerState(esm, ammdProvider, mappingConsumer, true));
        AbstractClassMetaData acmd = esm.getClassMetaData();
        esm.replaceFields(acmd.getAllMemberPositions(), (FieldManager)this);
        this.fieldManagerStateStack.removeFirst();
        return esm.getObject();
    }

    private Object checkAssignmentToNotNullField(Object val, int fieldNumber) {
        if (val != null) {
            return val;
        }
        AbstractMemberMetaData ammd = this.getMetaData(fieldNumber);
        String propertyName = this.getPropertyName(fieldNumber);
        String msg = String.format(ILLEGAL_NULL_ASSIGNMENT_ERROR_FORMAT, this.datastoreEntity.getKind(), this.datastoreEntity.getKey(), propertyName, ammd.getFullFieldName());
        throw new NullPointerException(msg);
    }

    public long fetchLongField(int fieldNumber) {
        return (Long)this.checkAssignmentToNotNullField(this.fetchObjectField(fieldNumber), fieldNumber);
    }

    public int fetchIntField(int fieldNumber) {
        return (Integer)this.checkAssignmentToNotNullField(this.fetchObjectField(fieldNumber), fieldNumber);
    }

    public float fetchFloatField(int fieldNumber) {
        return ((Float)this.checkAssignmentToNotNullField(this.fetchObjectField(fieldNumber), fieldNumber)).floatValue();
    }

    public double fetchDoubleField(int fieldNumber) {
        return (Double)this.checkAssignmentToNotNullField(this.fetchObjectField(fieldNumber), fieldNumber);
    }

    public char fetchCharField(int fieldNumber) {
        return ((Character)this.checkAssignmentToNotNullField(this.fetchObjectField(fieldNumber), fieldNumber)).charValue();
    }

    public byte fetchByteField(int fieldNumber) {
        return (Byte)this.checkAssignmentToNotNullField(this.fetchObjectField(fieldNumber), fieldNumber);
    }

    public boolean fetchBooleanField(int fieldNumber) {
        return (Boolean)this.checkAssignmentToNotNullField(this.fetchObjectField(fieldNumber), fieldNumber);
    }

    public void storeStringField(int fieldNumber, String value) {
        if (this.isPK(fieldNumber)) {
            this.storeStringPKField(fieldNumber, value);
        } else if (this.isParentPK(fieldNumber)) {
            this.storeParentStringField(value);
        } else if (this.isPKNameField(fieldNumber)) {
            this.storePKNameField(fieldNumber, value);
        } else {
            String valueToStore = value;
            AbstractMemberMetaData ammd = this.getMetaData(fieldNumber);
            if (ammd.getColumnMetaData() != null && ammd.getColumnMetaData().length == 1 && "CLOB".equals(ammd.getColumnMetaData()[0].getJdbcType())) {
                valueToStore = new Text(value);
            }
            this.storeObjectField(fieldNumber, valueToStore);
        }
    }

    void storePKIdField(int fieldNumber, Object value) {
        if (!this.fieldIsOfTypeLong(fieldNumber)) {
            throw new FatalNucleusUserException("Field with \"gae.pk-id\" extension must be of type Long");
        }
        Key key = null;
        if (value != null) {
            key = KeyFactory.createKey((String)this.datastoreEntity.getKind(), (long)((Long)value));
        }
        this.storeKeyPK(key);
        this.pkIdPos = fieldNumber;
    }

    private void storePKNameField(int fieldNumber, String value) {
        if (!this.fieldIsOfTypeString(fieldNumber)) {
            throw new FatalNucleusUserException("Field with \"gae.pk-id\" extension must be of type String");
        }
        Key key = null;
        if (value != null) {
            key = KeyFactory.createKey((Key)this.datastoreEntity.getParent(), (String)this.datastoreEntity.getKind(), (String)value);
        }
        this.storeKeyPK(key);
    }

    private void storeParentStringField(String value) {
        Key key = null;
        if (value != null) {
            try {
                key = KeyFactory.stringToKey((String)value);
            }
            catch (IllegalArgumentException iae) {
                throw new FatalNucleusUserException("Attempt was made to set parent to " + value + " but this cannot be converted into a Key.");
            }
        }
        this.storeParentKeyPK(key);
    }

    private void storeStringPKField(int fieldNumber, String value) {
        Key key = null;
        if (DatastoreManager.isEncodedPKField(this.getClassMetaData(), fieldNumber)) {
            if (value != null) {
                try {
                    key = KeyFactory.stringToKey((String)value);
                }
                catch (IllegalArgumentException iae) {
                    throw new FatalNucleusUserException("Invalid primary key for " + this.getClassMetaData().getFullClassName() + ".  The " + "primary key field is an encoded String but an unencoded value has been provided. " + "If you want to set an unencoded value on this field you can either change its " + "type to be an unencoded String (remove the \"" + "gae.encoded-pk" + "\" extension), change its type to be a " + Key.class.getName() + " and then set " + "the Key's name field, or create a separate String field for the name component " + "of your primary key and add the \"" + "gae.pk-name" + "\" extension.");
                }
            }
        } else {
            if (value == null) {
                throw new FatalNucleusUserException("Invalid primary key for " + this.getClassMetaData().getFullClassName() + ".  Cannot have " + "a null primary key field if the field is unencoded and of type String.  " + "Please provide a value or, if you want the datastore to generate an id on your " + "behalf, change the type of the field to Long.");
            }
            if (value != null) {
                key = this.datastoreEntity.getParent() != null ? new Entity(this.datastoreEntity.getKey().getKind(), value, this.datastoreEntity.getParent()).getKey() : new Entity(this.datastoreEntity.getKey().getKind(), value).getKey();
            }
        }
        this.storeKeyPK(key);
    }

    Object establishEntityGroup() {
        Key parentKey = this.getEntity().getParent();
        if (parentKey == null) {
            Object parentPojo;
            StateManager sm = this.getStateManager();
            parentKey = KeyRegistry.getKeyRegistry(this.getObjectManager()).getRegisteredKey(sm.getObject());
            if (parentKey == null) {
                parentKey = this.getParentKeyFromExternalFKMappings(sm);
            }
            if (parentKey == null) {
                parentKey = this.getParentKeyFromParentField(sm);
            }
            if (parentKey == null && (parentPojo = DatastoreJPACallbackHandler.getAttachingParent(sm.getObject())) != null) {
                parentKey = this.getKeyFromParentPojo(parentPojo);
            }
            if (parentKey != null) {
                this.recreateEntityWithParent(parentKey);
            }
        }
        if (parentKey != null && this.getParentMemberMetaData() != null) {
            return this.getParentMemberMetaData().getType().equals(Key.class) ? parentKey : KeyFactory.keyToString((Key)parentKey);
        }
        return null;
    }

    private Key getKeyFromParentPojo(Object mergeEntity) {
        StateManager sm = this.getObjectManager().findStateManager(mergeEntity);
        if (sm == null) {
            return null;
        }
        return EntityUtils.getPrimaryKeyAsKey(this.getObjectManager().getApiAdapter(), sm);
    }

    private Key getKeyForObject(Object pc) {
        ApiAdapter adapter = this.getStoreManager().getOMFContext().getApiAdapter();
        Object internalPk = adapter.getTargetKeyForSingleFieldIdentity(adapter.getIdForObject(pc));
        ObjectManager om = this.getObjectManager();
        AbstractClassMetaData acmd = om.getMetaDataManager().getMetaDataForClass(pc.getClass(), this.getClassLoaderResolver());
        return EntityUtils.getPkAsKey(internalPk, acmd, om);
    }

    private Key getParentKeyFromParentField(StateManager sm) {
        AbstractMemberMetaData parentField = this.getInsertMappingConsumer().getParentMappingField();
        if (parentField == null) {
            return null;
        }
        Object parent = sm.provideField(parentField.getAbsoluteFieldNumber());
        return parent == null ? null : this.getKeyForObject(parent);
    }

    private Key getParentKeyFromExternalFKMappings(StateManager sm) {
        Set<JavaTypeMapping> externalFKMappings = this.getInsertMappingConsumer().getExternalFKMappings();
        for (JavaTypeMapping fkMapping : externalFKMappings) {
            Object fkValue = sm.getAssociatedValue((Object)fkMapping);
            if (fkValue == null) continue;
            return this.getKeyForObject(fkValue);
        }
        return null;
    }

    void recreateEntityWithParent(Key parentKey) {
        Entity old = this.datastoreEntity;
        this.datastoreEntity = old.getKey().getName() != null ? new Entity(old.getKind(), old.getKey().getName(), parentKey) : new Entity(old.getKind(), parentKey);
        DatastoreFieldManager.copyProperties(old, this.datastoreEntity);
    }

    private void storeKeyPK(Key key) {
        if (key != null && !this.datastoreEntity.getKind().equals(key.getKind())) {
            throw new FatalNucleusUserException("Attempt was made to set the primray key of an entity with kind " + this.datastoreEntity.getKind() + " to a key with kind " + key.getKind());
        }
        if (this.datastoreEntity.getKey().isComplete()) {
            if (!this.datastoreEntity.getKey().equals((Object)key) && !this.keyAlreadySet) {
                throw new FatalNucleusUserException("Attempt was made to modify the primary key of an object of type " + this.getStateManager().getClassMetaData().getFullClassName() + " identified by " + "key " + this.datastoreEntity.getKey() + "  Primary keys are immutable.  " + "(New value: " + key);
            }
        } else if (key != null) {
            Entity old = this.datastoreEntity;
            if (key.getParent() != null) {
                if (this.keyAlreadySet) {
                    throw new FatalNucleusUserException(PARENT_ALREADY_SET);
                }
                this.parentAlreadySet = true;
            }
            this.datastoreEntity = new Entity(key);
            DatastoreFieldManager.copyProperties(old, this.datastoreEntity);
            this.keyAlreadySet = true;
        }
    }

    private static Map<String, Object> getPropertyMap(Entity entity) {
        try {
            return (Map)PROPERTY_MAP_FIELD.get(entity);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    static void copyProperties(Entity src, Entity dest) {
        for (Map.Entry<String, Object> entry : DatastoreFieldManager.getPropertyMap(src).entrySet()) {
            if (entry.getValue() != null && entry.getValue().getClass().getName().equals("com.google.appengine.api.datastore.Entity$UnindexedValue")) {
                dest.setUnindexedProperty(entry.getKey(), src.getProperty(entry.getKey()));
                continue;
            }
            dest.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private boolean isPKNameField(int fieldNumber) {
        return DatastoreManager.isPKNameField(this.getClassMetaData(), fieldNumber);
    }

    private boolean isPKIdField(int fieldNumber) {
        return DatastoreManager.isPKIdField(this.getClassMetaData(), fieldNumber);
    }

    private boolean isParentPK(int fieldNumber) {
        boolean result = DatastoreManager.isParentPKField(this.getClassMetaData(), fieldNumber);
        if (result) {
            this.parentMemberMetaData = this.getMetaData(fieldNumber);
        }
        return result;
    }

    private boolean isUnindexedProperty(AbstractMemberMetaData ammd) {
        return ammd.hasExtension("gae.unindexed");
    }

    public void storeShortField(int fieldNumber, short value) {
        this.storeObjectField(fieldNumber, value);
    }

    private void storePrimaryKey(int fieldNumber, Object value) {
        if (this.fieldIsOfTypeLong(fieldNumber)) {
            Key key = null;
            if (value != null) {
                key = KeyFactory.createKey((String)this.datastoreEntity.getKind(), (long)((Long)value));
            }
            this.storeKeyPK(key);
        } else if (this.fieldIsOfTypeKey(fieldNumber)) {
            Key key = (Key)value;
            if (key != null && key.getParent() != null && this.parentAlreadySet) {
                throw new FatalNucleusUserException(PARENT_ALREADY_SET);
            }
            this.storeKeyPK((Key)value);
        } else {
            throw this.exceptionForUnexpectedKeyType("Primary key", fieldNumber);
        }
    }

    void storeParentField(int fieldNumber, Object value) {
        if (!this.fieldIsOfTypeKey(fieldNumber)) {
            throw this.exceptionForUnexpectedKeyType("Parent primary key", fieldNumber);
        }
        this.storeParentKeyPK((Key)value);
    }

    public void storeObjectField(int fieldNumber, Object value) {
        if (this.isPK(fieldNumber)) {
            this.storePrimaryKey(fieldNumber, value);
        } else if (this.isParentPK(fieldNumber)) {
            this.storeParentField(fieldNumber, value);
        } else if (this.isPKIdField(fieldNumber)) {
            this.storePKIdField(fieldNumber, value);
        } else {
            ClassLoaderResolver clr = this.getClassLoaderResolver();
            AbstractMemberMetaData ammd = this.getMetaData(fieldNumber);
            if (this.repersistingForChildKeys && !PARENT_RELATION_TYPES.contains(ammd.getRelationType(clr))) {
                return;
            }
            if (value != null) {
                if (ammd.isSerialized()) {
                    value = this.serializationManager.serialize(clr, ammd, value);
                } else {
                    if (Enum.class.isAssignableFrom(ammd.getType())) {
                        value = ((Enum)value).name();
                    }
                    value = this.getConversionUtils().pojoValueToDatastoreValue(clr, value, ammd);
                }
            }
            if (ammd.getEmbeddedMetaData() != null) {
                this.storeEmbeddedField(ammd, fieldNumber, value);
            } else if (this.operation == Operation.INSERT && this.isInsertable(ammd) || this.operation == Operation.UPDATE && this.isUpdatable(ammd)) {
                if (ammd.getRelationType(clr) != 0 && !ammd.isSerialized()) {
                    DatastoreTable table;
                    if (!this.repersistingForChildKeys) {
                        this.relationFieldManager.storeRelationField(this.getClassMetaData(), ammd, value, this.createdWithoutEntity, this.getInsertMappingConsumer());
                    }
                    if ((table = this.getDatastoreTable()) != null && table.isParentKeyProvider(ammd)) {
                        return;
                    }
                    if (!this.getStoreManager().storageVersionAtLeast(StorageVersion.WRITE_OWNED_CHILD_KEYS_TO_PARENTS)) {
                        return;
                    }
                    value = this.extractRelationKeys(value);
                }
                value = this.unwrapSCOField(fieldNumber, value);
                String propName = EntityUtils.getPropertyName(this.getIdentifierFactory(), ammd);
                this.checkNullValue(ammd, propName, value);
                if (this.isUnindexedProperty(ammd)) {
                    this.datastoreEntity.setUnindexedProperty(propName, value);
                } else {
                    this.datastoreEntity.setProperty(propName, value);
                }
            }
        }
    }

    private ColumnMetaData getColumnMetaData(AbstractMemberMetaData ammd) {
        if (ammd.getColumnMetaData() != null && ammd.getColumnMetaData().length > 0) {
            return ammd.getColumnMetaData()[0];
        }
        if (ammd.getElementMetaData() != null && ammd.getElementMetaData().getColumnMetaData() != null && ammd.getElementMetaData().getColumnMetaData().length > 0) {
            return ammd.getElementMetaData().getColumnMetaData()[0];
        }
        return null;
    }

    private boolean isInsertable(AbstractMemberMetaData ammd) {
        ColumnMetaData cmd = this.getColumnMetaData(ammd);
        return cmd == null || cmd.getInsertable();
    }

    private boolean isUpdatable(AbstractMemberMetaData ammd) {
        ColumnMetaData cmd = this.getColumnMetaData(ammd);
        return cmd == null || cmd.getUpdateable();
    }

    private Object extractRelationKeys(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            int size = coll.size();
            List<Key> keys = this.extractRelationKeys((Collection)value);
            this.getStateManager().setAssociatedValue((Object)"___missing_relation_key___", this.repersistingForChildKeys && size != keys.size() ? Boolean.valueOf(true) : null);
            return keys;
        }
        Key key = this.extractChildKey(value);
        this.getStateManager().setAssociatedValue((Object)"___missing_relation_key___", this.repersistingForChildKeys && key == null ? Boolean.valueOf(true) : null);
        return key;
    }

    private List<Key> extractRelationKeys(Collection<?> values) {
        ArrayList<Object> keys = Utils.newArrayList(new Object[0]);
        for (Object obj : values) {
            Key key = this.extractChildKey(obj);
            if (key == null) continue;
            keys.add(key);
        }
        return keys;
    }

    private Key extractChildKey(Object value) {
        if (value == null) {
            return null;
        }
        ObjectManager om = this.getObjectManager();
        StateManager sm = om.findStateManager(value);
        if (sm == null) {
            return null;
        }
        if (sm.isDeleted((PersistenceCapable)sm.getObject())) {
            return null;
        }
        Object primaryKey = this.storeManager.getApiAdapter().getTargetKeyForSingleFieldIdentity(sm.getInternalObjectId());
        if (primaryKey == null) {
            return null;
        }
        Key key = EntityUtils.getPrimaryKeyAsKey(this.storeManager.getApiAdapter(), sm);
        if (key == null) {
            throw new NullPointerException("Could not extract a key from " + value);
        }
        if (key.getParent() == null) {
            throw new DatastoreRelationFieldManager.ChildWithoutParentException(this.datastoreEntity.getKey(), key);
        }
        if (!key.getParent().equals((Object)this.datastoreEntity.getKey())) {
            throw new DatastoreRelationFieldManager.ChildWithWrongParentException(this.datastoreEntity.getKey(), key);
        }
        return key;
    }

    Object unwrapSCOField(int fieldNumber, Object value) {
        return this.getStateManager().unwrapSCOField(fieldNumber, value, false);
    }

    boolean storeRelations() {
        return this.relationFieldManager.storeRelations(KeyRegistry.getKeyRegistry(this.getObjectManager()));
    }

    ClassLoaderResolver getClassLoaderResolver() {
        return this.getObjectManager().getClassLoaderResolver();
    }

    StateManager getStateManager() {
        return this.fieldManagerStateStack.getFirst().stateManager;
    }

    ObjectManager getObjectManager() {
        return this.getStateManager().getObjectManager();
    }

    InsertMappingConsumer getInsertMappingConsumer() {
        return this.fieldManagerStateStack.getFirst().mappingConsumer;
    }

    private void storeEmbeddedField(AbstractMemberMetaData ammd, int fieldNumber, Object value) {
        StateManager esm = this.getEmbeddedStateManager(ammd, fieldNumber, value);
        InsertMappingConsumer mc = this.buildMappingConsumer(esm.getClassMetaData(), this.getClassLoaderResolver(), esm.getClassMetaData().getAllMemberPositions(), ammd.getEmbeddedMetaData());
        AbstractMemberMetaDataProvider ammdProvider = this.getEmbeddedAbstractMemberMetaDataProvider(mc);
        this.fieldManagerStateStack.addFirst(new FieldManagerState(esm, ammdProvider, mc, true));
        AbstractClassMetaData acmd = esm.getClassMetaData();
        esm.provideFields(acmd.getAllMemberPositions(), (FieldManager)this);
        this.fieldManagerStateStack.removeFirst();
    }

    private void storeParentKeyPK(Key key) {
        if (key != null && this.parentAlreadySet) {
            throw new FatalNucleusUserException(PARENT_ALREADY_SET);
        }
        if (this.datastoreEntity.getParent() != null) {
            if (!this.datastoreEntity.getParent().equals((Object)key) && !this.parentAlreadySet) {
                throw new FatalNucleusUserException("Attempt was made to modify the parent of an object of type " + this.getStateManager().getClassMetaData().getFullClassName() + " identified by " + "key " + this.datastoreEntity.getKey() + ".  Parents are immutable (changed value is " + key + ").");
            }
        } else if (key != null) {
            if (!this.createdWithoutEntity) {
                throw new FatalNucleusUserException("You can only rely on this class to properly handle parent pks if you instantiated the class without providing a datastore entity to the constructor.");
            }
            if (this.keyAlreadySet) {
                throw new FatalNucleusUserException(PARENT_ALREADY_SET);
            }
            this.recreateEntityWithParent(key);
            this.parentAlreadySet = true;
        }
    }

    public void storeLongField(int fieldNumber, long value) {
        this.storeObjectField(fieldNumber, value);
    }

    public void storeIntField(int fieldNumber, int value) {
        this.storeObjectField(fieldNumber, value);
    }

    public void storeFloatField(int fieldNumber, float value) {
        this.storeObjectField(fieldNumber, Float.valueOf(value));
    }

    public void storeDoubleField(int fieldNumber, double value) {
        this.storeObjectField(fieldNumber, value);
    }

    public void storeCharField(int fieldNumber, char value) {
        this.storeObjectField(fieldNumber, Character.valueOf(value));
    }

    public void storeByteField(int fieldNumber, byte value) {
        this.storeObjectField(fieldNumber, value);
    }

    public void storeBooleanField(int fieldNumber, boolean value) {
        this.storeObjectField(fieldNumber, value);
    }

    private boolean isPK(int fieldNumber) {
        if (this.fieldManagerStateStack.getFirst().isEmbedded) {
            return false;
        }
        int[] pkPositions = this.getClassMetaData().getPKMemberPositions();
        return pkPositions != null && pkPositions[0] == fieldNumber;
    }

    private String getPropertyName(int fieldNumber) {
        AbstractMemberMetaData ammd = this.getMetaData(fieldNumber);
        return EntityUtils.getPropertyName(this.getIdentifierFactory(), ammd);
    }

    private AbstractMemberMetaData getMetaData(int fieldNumber) {
        return this.fieldManagerStateStack.getFirst().abstractMemberMetaDataProvider.get(fieldNumber);
    }

    private void checkNullValue(AbstractMemberMetaData ammd, String propName, Object value) {
        if (value == null && ammd.getNullValue() == NullValue.EXCEPTION) {
            throw new NucleusUserException("Field " + ammd.getFullFieldName() + " is null, but is mandatory as it's described in the jdo metadata");
        }
    }

    AbstractClassMetaData getClassMetaData() {
        return this.getStateManager().getClassMetaData();
    }

    Entity getEntity() {
        return this.datastoreEntity;
    }

    private IdentifierFactory getIdentifierFactory() {
        return this.storeManager.getIdentifierFactory();
    }

    AbstractMemberMetaData getParentMemberMetaData() {
        return this.parentMemberMetaData;
    }

    DatastoreManager getStoreManager() {
        return this.storeManager;
    }

    boolean handleIndexFields() {
        Set<JavaTypeMapping> orderMappings = this.getInsertMappingConsumer().getExternalOrderMappings();
        boolean delayWrite = false;
        for (JavaTypeMapping orderMapping : orderMappings) {
            if (!(orderMapping instanceof IndexMapping)) continue;
            delayWrite = true;
            Object orderValue = this.getStateManager().getAssociatedValue((Object)orderMapping);
            if (orderValue == null) continue;
            delayWrite = false;
            orderMapping.setObject(this.getObjectManager(), (Object)this.getEntity(), NOT_USED, orderValue);
        }
        return delayWrite;
    }

    private InsertMappingConsumer buildMappingConsumer(AbstractClassMetaData acmd, ClassLoaderResolver clr, int[] fieldNumbers) {
        return this.buildMappingConsumer(acmd, clr, fieldNumbers, null);
    }

    private InsertMappingConsumer buildMappingConsumer(AbstractClassMetaData acmd, ClassLoaderResolver clr, int[] fieldNumbers, EmbeddedMetaData emd) {
        DatastoreTable table = this.getStoreManager().getDatastoreClass(acmd.getFullClassName(), clr);
        if (table == null) {
            throw new NoPersistenceInformationException(acmd.getFullClassName());
        }
        InsertMappingConsumer consumer = new InsertMappingConsumer(acmd);
        if (emd == null) {
            table.provideDatastoreIdMappings(consumer);
            table.providePrimaryKeyMappings(consumer);
        }
        table.provideParentMappingField(consumer);
        if (this.createdWithoutEntity || emd != null) {
            table.provideNonPrimaryKeyMappings(consumer, emd != null);
            table.provideExternalMappings(consumer, 5);
            table.provideExternalMappings(consumer, 4);
        } else {
            AbstractMemberMetaData[] fmds = new AbstractMemberMetaData[fieldNumbers.length];
            if (fieldNumbers.length > 0) {
                for (int i = 0; i < fieldNumbers.length; ++i) {
                    fmds[i] = acmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
                }
            }
            table.provideMappingsForMembers(consumer, fmds, false);
        }
        if (emd != null) {
            DatastoreTable parentTable = this.getStoreManager().getDatastoreClass(this.getClassMetaData().getFullClassName(), clr);
            AbstractMemberMetaData parentField = (AbstractMemberMetaData)emd.getParent();
            EmbeddedMapping embeddedMapping = (EmbeddedMapping)parentTable.getMappingForFullFieldName(parentField.getFullFieldName());
            HashMap<String, AbstractMemberMetaData> embeddedMetaDataByFullFieldName = Utils.newHashMap();
            int numMappings = embeddedMapping.getNumberOfJavaTypeMappings();
            for (int i = 0; i < numMappings; ++i) {
                JavaTypeMapping fieldMapping = embeddedMapping.getJavaTypeMapping(i);
                AbstractMemberMetaData ammd = fieldMapping.getMemberMetaData();
                embeddedMetaDataByFullFieldName.put(ammd.getFullFieldName(), ammd);
            }
            HashMap<Integer, AbstractMemberMetaData> map = new HashMap<Integer, AbstractMemberMetaData>(consumer.getFieldIndexToMemberMetaData());
            for (Map.Entry entry : map.entrySet()) {
                AbstractMemberMetaData replacement = (AbstractMemberMetaData)embeddedMetaDataByFullFieldName.get(((AbstractMemberMetaData)entry.getValue()).getFullFieldName());
                if (replacement == null) {
                    throw new RuntimeException("Unable to locate " + ((AbstractMemberMetaData)entry.getValue()).getFullFieldName() + " in embedded meta-data " + "map.  This is most likely an App Engine bug.");
                }
                consumer.getFieldIndexToMemberMetaData().put((Integer)entry.getKey(), replacement);
            }
        }
        return consumer;
    }

    TypeConversionUtils getConversionUtils() {
        return TYPE_CONVERSION_UTILS;
    }

    Integer getPkIdPos() {
        return this.pkIdPos;
    }

    void setRepersistingForChildKeys(boolean repersistingForChildKeys) {
        this.repersistingForChildKeys = repersistingForChildKeys;
    }

    DatastoreTable getDatastoreTable() {
        return this.storeManager.getDatastoreClass(this.getClassMetaData().getFullClassName(), this.getClassLoaderResolver());
    }

    static {
        try {
            PROPERTY_MAP_FIELD = Entity.class.getDeclaredField("propertyMap");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        PROPERTY_MAP_FIELD.setAccessible(true);
    }

    private static final class FieldManagerState {
        private final StateManager stateManager;
        private final AbstractMemberMetaDataProvider abstractMemberMetaDataProvider;
        private final InsertMappingConsumer mappingConsumer;
        private final boolean isEmbedded;

        private FieldManagerState(StateManager stateManager, AbstractMemberMetaDataProvider abstractMemberMetaDataProvider, InsertMappingConsumer mappingConsumer, boolean isEmbedded) {
            this.stateManager = stateManager;
            this.abstractMemberMetaDataProvider = abstractMemberMetaDataProvider;
            this.mappingConsumer = mappingConsumer;
            this.isEmbedded = isEmbedded;
        }
    }

    private static interface AbstractMemberMetaDataProvider {
        public AbstractMemberMetaData get(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        INSERT,
        UPDATE,
        DELETE,
        READ;

    }
}

