/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class MultiMap
extends HashMap {
    private transient Collection values = null;

    public MultiMap() {
    }

    public MultiMap(int initialCapacity) {
        super(initialCapacity);
    }

    public MultiMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public MultiMap(MultiMap map) {
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                super.put(entry.getKey(), new ArrayList((List)entry.getValue()));
            }
        }
    }

    public boolean containsValue(Object value) {
        Set pairs = super.entrySet();
        if (pairs == null) {
            return false;
        }
        for (Map.Entry keyValuePair : pairs) {
            Collection coll = (Collection)keyValuePair.getValue();
            if (!coll.contains(value)) continue;
            return true;
        }
        return false;
    }

    public Object put(Object key, Object value) {
        boolean results;
        Collection c = (Collection)super.get(key);
        if (c == null) {
            c = this.createCollection(null);
            super.put(key, c);
        }
        return (results = c.add(value)) ? value : null;
    }

    public Object remove(Object key, Object item) {
        Collection valuesForKey = (Collection)super.get(key);
        if (valuesForKey == null) {
            return null;
        }
        valuesForKey.remove(item);
        if (valuesForKey.isEmpty()) {
            this.remove(key);
        }
        return item;
    }

    public void clear() {
        Set pairs = super.entrySet();
        for (Map.Entry keyValuePair : pairs) {
            Collection coll = (Collection)keyValuePair.getValue();
            coll.clear();
        }
        super.clear();
    }

    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new ValueElement());
    }

    public Object clone() {
        MultiMap obj = (MultiMap)super.clone();
        for (Map.Entry entry : this.entrySet()) {
            Collection coll = (Collection)entry.getValue();
            Collection newColl = this.createCollection(coll);
            entry.setValue(newColl);
        }
        return obj;
    }

    protected Collection createCollection(Collection c) {
        if (c == null) {
            return new ArrayList();
        }
        return new ArrayList(c);
    }

    private class ValueElementIter
    implements Iterator {
        private Iterator backing;
        private Iterator temp;

        private ValueElementIter() {
            this.backing = MultiMap.super.values().iterator();
        }

        private boolean searchNextIterator() {
            while (this.temp == null || !this.temp.hasNext()) {
                if (!this.backing.hasNext()) {
                    return false;
                }
                this.temp = ((Collection)this.backing.next()).iterator();
            }
            return true;
        }

        public boolean hasNext() {
            return this.searchNextIterator();
        }

        public Object next() {
            if (!this.searchNextIterator()) {
                throw new NoSuchElementException();
            }
            return this.temp.next();
        }

        public void remove() {
            if (this.temp == null) {
                throw new IllegalStateException();
            }
            this.temp.remove();
        }
    }

    private class ValueElement
    extends AbstractCollection {
        private ValueElement() {
        }

        public Iterator iterator() {
            return new ValueElementIter();
        }

        public int size() {
            int i = 0;
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                iter.next();
                ++i;
            }
            return i;
        }

        public void clear() {
            MultiMap.this.clear();
        }
    }
}

