package com.jispot.common;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

public class RequestUtils {

    
    /**
     * Return the parameter or the attribute value from the object HttpServletRequest. If parameter is not in the
     * request this methods returns an empty String
     * 
     * @param request the HttpServletRequest we are looking into
     * @param key the key of the parameter we're looking for
     * @return the attribute or an empty string.
     */
    public static String getAttributeOrParameter( HttpServletRequest request , String key ) {
        String res = "";
        if (isPost(request)) {
            res = ( String ) request.getAttribute( key );
        }
        else {
            res = request.getParameter( key );
        }
        if ( StringUtils.isNullOrEmpty( res ) ) {
            res = "";
        }
        return res;
    }

    /**
     * Return the parameter or the attribute value from the object HttpServletRequest. If parameter is not in the
     * request this methods returns an empty String
     * 
     * @param request the HttpServletRequest we are looking into
     * @param key the key of the parameter we're looking for
     * @return the attribute or an empty string.
     */
    public static boolean isPost( HttpServletRequest request ) {
        return "POST".equalsIgnoreCase( request.getMethod());
    }

    /**
     * Return a List of Param from the request.
     * This list comes from either attributes or parameters
     * depending on the request Method (GET or POST)
     * 
     * @param request the HttpServletRequest we are looking into
     * @return a List<Param> containing everything from the request
     */
    @SuppressWarnings("unchecked")
    public static List<Param> getAttributesOrParameters( HttpServletRequest request ) {

        List<Param> params = new ArrayList<Param>( request.getParameterMap().size() - 2 );
        if (isPost(request)) {
            Enumeration<String> parameters = request.getAttributeNames();
            while ( parameters.hasMoreElements() ) {
                String name = ( String ) parameters.nextElement();
                // beware if we have something else than strings in POST attribute !! 
                params.add( new Param( name , (String) request.getAttribute( name ) ) );            
            }
        }
        else {
            Enumeration<String> parameters = request.getParameterNames();
            while ( parameters.hasMoreElements() ) {
                String name = ( String ) parameters.nextElement();
                params.add( new Param( name , request.getParameter( name ) ) );            
            }
        }
        return params;
    }

}
