/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.util.ClassUtils;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstructorResolver {
    private static final String CONSTRUCTOR_PROPERTIES_CLASS_NAME = "java.beans.ConstructorProperties";
    private static final boolean constructorPropertiesAnnotationAvailable = ClassUtils.isPresent((String)"java.beans.ConstructorProperties", (ClassLoader)ConstructorResolver.class.getClassLoader());
    private final AbstractAutowireCapableBeanFactory beanFactory;

    public ConstructorResolver(AbstractAutowireCapableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public BeanWrapper autowireConstructor(final String beanName, final RootBeanDefinition mbd, Constructor[] chosenCtors, Object[] explicitArgs) {
        block34: {
            bw = new BeanWrapperImpl();
            this.beanFactory.initBeanWrapper(bw);
            constructorToUse = null;
            argsToUse = null;
            if (explicitArgs != null) {
                argsToUse = explicitArgs;
            } else {
                constructorToUse = (Constructor)mbd.resolvedConstructorOrFactoryMethod;
                if (constructorToUse != null && (argsToUse = mbd.resolvedConstructorArguments) == null) {
                    argsToUse = this.resolvePreparedArguments(beanName, mbd, bw, constructorToUse);
                }
            }
            if (constructorToUse != null) break block34;
            autowiring = chosenCtors != null || mbd.getResolvedAutowireMode() == 3;
            resolvedValues = null;
            if (explicitArgs != null) {
                minNrOfArgs = explicitArgs.length;
            } else {
                cargs = mbd.getConstructorArgumentValues();
                resolvedValues = new ConstructorArgumentValues();
                minNrOfArgs = this.resolveConstructorArguments(beanName, mbd, bw, cargs, resolvedValues);
            }
            candidates = chosenCtors;
            if (candidates == null) {
                beanClass = mbd.getBeanClass();
                try {
                    candidates = mbd.isNonPublicAccessAllowed() != false ? beanClass.getDeclaredConstructors() : beanClass.getConstructors();
                }
                catch (Throwable ex) {
                    throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Resolution of declared constructors on bean Class [" + beanClass.getName() + "] from ClassLoader [" + beanClass.getClassLoader() + "] failed", ex);
                }
            }
            AutowireUtils.sortConstructors(candidates);
            minTypeDiffWeight = 0x7FFFFFFF;
            ambiguousConstructors = null;
            i = 0;
            while (i < candidates.length) {
                block36: {
                    block31: {
                        block35: {
                            block32: {
                                block33: {
                                    candidate = candidates[i];
                                    paramTypes = candidate.getParameterTypes();
                                    if (constructorToUse != null && argsToUse.length > paramTypes.length) break;
                                    if (paramTypes.length < minNrOfArgs) {
                                        throw new BeanCreationException(mbd.getResourceDescription(), beanName, String.valueOf(minNrOfArgs) + " constructor arguments specified but no matching constructor found in bean '" + beanName + "' " + "(hint: specify index/type/name arguments for simple parameters to avoid type ambiguities)");
                                    }
                                    causes = null;
                                    if (resolvedValues == null) break block35;
                                    try {
                                        paramNames = null;
                                        if (ConstructorResolver.constructorPropertiesAnnotationAvailable) {
                                            paramNames = ConstructorPropertiesChecker.evaluateAnnotation(candidate, paramTypes.length);
                                        }
                                        if (paramNames == null && (pnd = this.beanFactory.getParameterNameDiscoverer()) != null) {
                                            paramNames = pnd.getParameterNames(candidate);
                                        }
                                        args = this.createArgumentArray(beanName, mbd, resolvedValues, bw, paramTypes, paramNames, candidate, autowiring);
                                        break block31;
                                    }
                                    catch (UnsatisfiedDependencyException ex) {
                                        if (this.beanFactory.logger.isTraceEnabled()) {
                                            this.beanFactory.logger.trace((Object)("Ignoring constructor [" + candidate + "] of bean '" + beanName + "': " + (Object)ex));
                                        }
                                        if (i != candidates.length - 1 || constructorToUse != null) break block32;
                                        if (causes == null) break block33;
                                        ** for (cause : causes)
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        this.beanFactory.onSuppressedException(cause);
                                        continue;
                                    }
                                }
                                throw ex;
                            }
                            if (causes == null) {
                                causes = new LinkedList<UnsatisfiedDependencyException>();
                            }
                            causes.add(ex);
                            break block36;
                        }
                        if (paramTypes.length != explicitArgs.length) break block36;
                        args = new ArgumentsHolder(explicitArgs);
                    }
                    v0 = typeDiffWeight = mbd.isLenientConstructorResolution() != false ? args.getTypeDifferenceWeight(paramTypes) : args.getAssignabilityWeight(paramTypes);
                    if (typeDiffWeight < minTypeDiffWeight) {
                        constructorToUse = candidate;
                        argsToUse = args.arguments;
                        minTypeDiffWeight = typeDiffWeight;
                        ambiguousConstructors = null;
                    } else if (constructorToUse != null && typeDiffWeight == minTypeDiffWeight) {
                        if (ambiguousConstructors == null) {
                            ambiguousConstructors = new LinkedHashSet<Constructor>();
                            ambiguousConstructors.add(constructorToUse);
                        }
                        ambiguousConstructors.add(candidate);
                    }
                }
                ++i;
            }
            if (constructorToUse == null) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Could not resolve matching constructor");
            }
            if (ambiguousConstructors != null && !mbd.isLenientConstructorResolution()) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Ambiguous constructor matches found in bean '" + beanName + "' " + "(hint: specify index/type/name arguments for simple parameters to avoid type ambiguities): " + ambiguousConstructors);
            }
            if (explicitArgs == null) {
                mbd.resolvedConstructorOrFactoryMethod = constructorToUse;
            }
        }
        try {
            if (System.getSecurityManager() != null) {
                ctorToUse = constructorToUse;
                argumentsToUse = argsToUse;
                beanInstance = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return ConstructorResolver.this.beanFactory.getInstantiationStrategy().instantiate(mbd, beanName, ConstructorResolver.this.beanFactory, ctorToUse, argumentsToUse);
                    }
                }, this.beanFactory.getAccessControlContext());
            } else {
                beanInstance = this.beanFactory.getInstantiationStrategy().instantiate(mbd, beanName, this.beanFactory, constructorToUse, argsToUse);
            }
            bw.setWrappedInstance(beanInstance);
            return bw;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Instantiation of bean failed", ex);
        }
    }

    public void resolveFactoryMethodIfPossible(RootBeanDefinition mbd) {
        Class<Object> factoryClass = mbd.getFactoryBeanName() != null ? this.beanFactory.getType(mbd.getFactoryBeanName()) : mbd.getBeanClass();
        factoryClass = ClassUtils.getUserClass(factoryClass);
        Method[] candidates = ReflectionUtils.getAllDeclaredMethods((Class)factoryClass);
        Method uniqueCandidate = null;
        Method[] methodArray = candidates;
        int n = candidates.length;
        int n2 = 0;
        while (n2 < n) {
            Method candidate = methodArray[n2];
            if (mbd.isFactoryMethod(candidate)) {
                if (uniqueCandidate == null) {
                    uniqueCandidate = candidate;
                } else if (!Arrays.equals(uniqueCandidate.getParameterTypes(), candidate.getParameterTypes())) {
                    uniqueCandidate = null;
                    break;
                }
            }
            ++n2;
        }
        mbd.resolvedConstructorOrFactoryMethod = uniqueCandidate;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public BeanWrapper instantiateUsingFactoryMethod(final String beanName, final RootBeanDefinition mbd, Object[] explicitArgs) {
        block38: {
            block39: {
                bw = new BeanWrapperImpl();
                this.beanFactory.initBeanWrapper(bw);
                factoryBeanName = mbd.getFactoryBeanName();
                if (factoryBeanName != null) {
                    if (factoryBeanName.equals(beanName)) {
                        throw new BeanDefinitionStoreException(mbd.getResourceDescription(), beanName, "factory-bean reference points back to the same bean definition");
                    }
                    factoryBean = this.beanFactory.getBean(factoryBeanName);
                    if (factoryBean == null) {
                        throw new BeanCreationException(mbd.getResourceDescription(), beanName, "factory-bean '" + factoryBeanName + "' returned null");
                    }
                    factoryClass = factoryBean.getClass();
                    isStatic = false;
                } else {
                    if (!mbd.hasBeanClass()) {
                        throw new BeanDefinitionStoreException(mbd.getResourceDescription(), beanName, "bean definition declares neither a bean class nor a factory-bean reference");
                    }
                    factoryBean = null;
                    factoryClass = mbd.getBeanClass();
                    isStatic = true;
                }
                factoryMethodToUse = null;
                argsToUse = null;
                if (explicitArgs != null) {
                    argsToUse = explicitArgs;
                } else {
                    factoryMethodToUse = (Method)mbd.resolvedConstructorOrFactoryMethod;
                    if (factoryMethodToUse != null && (argsToUse = mbd.resolvedConstructorArguments) == null && mbd.preparedConstructorArguments != null) {
                        argsToUse = this.resolvePreparedArguments(beanName, mbd, bw, factoryMethodToUse);
                    }
                }
                if (factoryMethodToUse != null && argsToUse != null) break block39;
                factoryClass = ClassUtils.getUserClass(factoryClass);
                rawCandidates = null;
                factoryClazz = factoryClass;
                rawCandidates = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                    @Override
                    public Method[] run() {
                        return mbd.isNonPublicAccessAllowed() ? ReflectionUtils.getAllDeclaredMethods((Class)factoryClazz) : factoryClazz.getMethods();
                    }
                }) : (mbd.isNonPublicAccessAllowed() != false ? ReflectionUtils.getAllDeclaredMethods((Class)factoryClazz) : factoryClazz.getMethods());
                candidateSet = new ArrayList<Method>();
                var17_15 = rawCandidates;
                var16_17 = rawCandidates.length;
                var15_18 = 0;
                while (var15_18 < var16_17) {
                    candidate = var17_15[var15_18];
                    if (Modifier.isStatic(candidate.getModifiers()) == isStatic && candidate.getName().equals(mbd.getFactoryMethodName()) && mbd.isFactoryMethod(candidate)) {
                        candidateSet.add(candidate);
                    }
                    ++var15_18;
                }
                candidates = candidateSet.toArray(new Method[candidateSet.size()]);
                AutowireUtils.sortFactoryMethods(candidates);
                resolvedValues = null;
                autowiring = mbd.getResolvedAutowireMode() == 3;
                minTypeDiffWeight = 0x7FFFFFFF;
                ambiguousFactoryMethods = null;
                if (explicitArgs != null) {
                    minNrOfArgs = explicitArgs.length;
                } else {
                    cargs = mbd.getConstructorArgumentValues();
                    resolvedValues = new ConstructorArgumentValues();
                    minNrOfArgs = this.resolveConstructorArguments(beanName, mbd, bw, cargs, resolvedValues);
                }
                causes = null;
                i = 0;
                while (i < candidates.length) {
                    block40: {
                        block35: {
                            block41: {
                                block36: {
                                    block37: {
                                        candidate = candidates[i];
                                        paramTypes = candidate.getParameterTypes();
                                        if (paramTypes.length < minNrOfArgs) break block40;
                                        if (resolvedValues == null) break block41;
                                        try {
                                            paramNames = null;
                                            pnd = this.beanFactory.getParameterNameDiscoverer();
                                            if (pnd != null) {
                                                paramNames = pnd.getParameterNames(candidate);
                                            }
                                            args = this.createArgumentArray(beanName, mbd, resolvedValues, bw, paramTypes, paramNames, candidate, autowiring);
                                            break block35;
                                        }
                                        catch (UnsatisfiedDependencyException ex) {
                                            if (this.beanFactory.logger.isTraceEnabled()) {
                                                this.beanFactory.logger.trace((Object)("Ignoring factory method [" + candidate + "] of bean '" + beanName + "': " + (Object)ex));
                                            }
                                            if (i != candidates.length - 1 || factoryMethodToUse != null) break block36;
                                            if (causes == null) break block37;
                                            ** for (cause : causes)
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            this.beanFactory.onSuppressedException(cause);
                                            continue;
                                        }
                                    }
                                    throw ex;
                                }
                                if (causes == null) {
                                    causes = new LinkedList<UnsatisfiedDependencyException>();
                                }
                                causes.add(ex);
                                break block40;
                            }
                            if (paramTypes.length != explicitArgs.length) break block40;
                            args = new ArgumentsHolder(explicitArgs);
                        }
                        v0 = typeDiffWeight = mbd.isLenientConstructorResolution() != false ? args.getTypeDifferenceWeight(paramTypes) : args.getAssignabilityWeight(paramTypes);
                        if (typeDiffWeight < minTypeDiffWeight) {
                            factoryMethodToUse = candidate;
                            argsToUse = args.arguments;
                            minTypeDiffWeight = typeDiffWeight;
                            ambiguousFactoryMethods = null;
                        } else if (factoryMethodToUse != null && typeDiffWeight == minTypeDiffWeight) {
                            if (ambiguousFactoryMethods == null) {
                                ambiguousFactoryMethods = new LinkedHashSet<Method>();
                                ambiguousFactoryMethods.add(factoryMethodToUse);
                            }
                            ambiguousFactoryMethods.add(candidate);
                        }
                    }
                    ++i;
                }
                if (factoryMethodToUse == null) {
                    throw new BeanCreationException(mbd.getResourceDescription(), beanName, "No matching factory method found: " + (mbd.getFactoryBeanName() != null ? "factory bean '" + mbd.getFactoryBeanName() + "'; " : "") + "factory method '" + mbd.getFactoryMethodName() + "'");
                }
                if (Void.TYPE.equals(factoryMethodToUse.getReturnType())) {
                    throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Invalid factory method '" + mbd.getFactoryMethodName() + "': needs to have a non-void return type!");
                }
                if (ambiguousFactoryMethods != null && !mbd.isLenientConstructorResolution()) {
                    throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Ambiguous factory method matches found in bean '" + beanName + "' " + "(hint: specify index/type/name arguments for simple parameters to avoid type ambiguities): " + ambiguousFactoryMethods);
                }
                if (explicitArgs == null) {
                    mbd.resolvedConstructorOrFactoryMethod = factoryMethodToUse;
                }
            }
            try {
                if (System.getSecurityManager() != null) {
                    fb = factoryBean;
                    factoryMethod = factoryMethodToUse;
                    args = argsToUse;
                    beanInstance = AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            return ConstructorResolver.this.beanFactory.getInstantiationStrategy().instantiate(mbd, beanName, ConstructorResolver.this.beanFactory, fb, factoryMethod, args);
                        }
                    }, this.beanFactory.getAccessControlContext());
                } else {
                    beanInstance = this.beanFactory.getInstantiationStrategy().instantiate(mbd, beanName, this.beanFactory, factoryBean, factoryMethodToUse, argsToUse);
                }
                if (beanInstance != null) break block38;
                return null;
            }
            catch (Throwable ex) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Instantiation of bean failed", ex);
            }
        }
        bw.setWrappedInstance(beanInstance);
        return bw;
    }

    private int resolveConstructorArguments(String beanName, RootBeanDefinition mbd, BeanWrapper bw, ConstructorArgumentValues cargs, ConstructorArgumentValues resolvedValues) {
        BeanWrapper converter = this.beanFactory.getCustomTypeConverter() != null ? this.beanFactory.getCustomTypeConverter() : bw;
        BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this.beanFactory, beanName, mbd, converter);
        int minNrOfArgs = cargs.getArgumentCount();
        for (Map.Entry<Integer, ConstructorArgumentValues.ValueHolder> entry : cargs.getIndexedArgumentValues().entrySet()) {
            ConstructorArgumentValues.ValueHolder valueHolder;
            int index = entry.getKey();
            if (index < 0) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Invalid constructor argument index: " + index);
            }
            if (index > minNrOfArgs) {
                minNrOfArgs = index + 1;
            }
            if ((valueHolder = entry.getValue()).isConverted()) {
                resolvedValues.addIndexedArgumentValue(index, valueHolder);
                continue;
            }
            Object resolvedValue = valueResolver.resolveValueIfNecessary("constructor argument", valueHolder.getValue());
            ConstructorArgumentValues.ValueHolder resolvedValueHolder = new ConstructorArgumentValues.ValueHolder(resolvedValue, valueHolder.getType(), valueHolder.getName());
            resolvedValueHolder.setSource(valueHolder);
            resolvedValues.addIndexedArgumentValue(index, resolvedValueHolder);
        }
        for (ConstructorArgumentValues.ValueHolder valueHolder : cargs.getGenericArgumentValues()) {
            if (valueHolder.isConverted()) {
                resolvedValues.addGenericArgumentValue(valueHolder);
                continue;
            }
            Object resolvedValue = valueResolver.resolveValueIfNecessary("constructor argument", valueHolder.getValue());
            ConstructorArgumentValues.ValueHolder resolvedValueHolder = new ConstructorArgumentValues.ValueHolder(resolvedValue, valueHolder.getType(), valueHolder.getName());
            resolvedValueHolder.setSource(valueHolder);
            resolvedValues.addGenericArgumentValue(resolvedValueHolder);
        }
        return minNrOfArgs;
    }

    private ArgumentsHolder createArgumentArray(String beanName, RootBeanDefinition mbd, ConstructorArgumentValues resolvedValues, BeanWrapper bw, Class[] paramTypes, String[] paramNames, Object methodOrCtor, boolean autowiring) throws UnsatisfiedDependencyException {
        String methodType = methodOrCtor instanceof Constructor ? "constructor" : "factory method";
        BeanWrapper converter = this.beanFactory.getCustomTypeConverter() != null ? this.beanFactory.getCustomTypeConverter() : bw;
        ArgumentsHolder args = new ArgumentsHolder(paramTypes.length);
        HashSet<ConstructorArgumentValues.ValueHolder> usedValueHolders = new HashSet<ConstructorArgumentValues.ValueHolder>(paramTypes.length);
        LinkedHashSet<String> autowiredBeanNames = new LinkedHashSet<String>(4);
        boolean resolveNecessary = false;
        int paramIndex = 0;
        while (paramIndex < paramTypes.length) {
            Class paramType = paramTypes[paramIndex];
            String paramName = paramNames != null ? paramNames[paramIndex] : null;
            ConstructorArgumentValues.ValueHolder valueHolder = resolvedValues.getArgumentValue(paramIndex, paramType, paramName, usedValueHolders);
            if (valueHolder == null && !autowiring) {
                valueHolder = resolvedValues.getGenericArgumentValue(null, null, usedValueHolders);
            }
            if (valueHolder != null) {
                Object convertedValue;
                usedValueHolders.add(valueHolder);
                ConstructorArgumentValues.ValueHolder sourceHolder = (ConstructorArgumentValues.ValueHolder)valueHolder.getSource();
                Object originalValue = valueHolder.getValue();
                Object sourceValue = sourceHolder.getValue();
                if (valueHolder.isConverted()) {
                    args.preparedArguments[paramIndex] = convertedValue = valueHolder.getConvertedValue();
                } else {
                    try {
                        convertedValue = converter.convertIfNecessary(originalValue, paramType, MethodParameter.forMethodOrConstructor((Object)methodOrCtor, (int)paramIndex));
                        if (originalValue == sourceValue || sourceValue instanceof TypedStringValue) {
                            sourceHolder.setConvertedValue(convertedValue);
                            args.preparedArguments[paramIndex] = convertedValue;
                        } else {
                            resolveNecessary = true;
                            args.preparedArguments[paramIndex] = sourceValue;
                        }
                    }
                    catch (TypeMismatchException ex) {
                        throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, paramIndex, paramType, "Could not convert " + methodType + " argument value of type [" + ObjectUtils.nullSafeClassName((Object)valueHolder.getValue()) + "] to required type [" + paramType.getName() + "]: " + ex.getMessage());
                    }
                }
                args.arguments[paramIndex] = convertedValue;
                args.rawArguments[paramIndex] = originalValue;
            } else {
                if (!autowiring) {
                    throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, paramIndex, paramType, "Ambiguous " + methodType + " argument types - " + "did you specify the correct bean references as " + methodType + " arguments?");
                }
                try {
                    Object autowiredArgument;
                    MethodParameter param = MethodParameter.forMethodOrConstructor((Object)methodOrCtor, (int)paramIndex);
                    args.rawArguments[paramIndex] = autowiredArgument = this.resolveAutowiredArgument(param, beanName, autowiredBeanNames, converter);
                    args.arguments[paramIndex] = autowiredArgument;
                    args.preparedArguments[paramIndex] = new AutowiredArgumentMarker();
                    resolveNecessary = true;
                }
                catch (BeansException ex) {
                    throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, paramIndex, paramType, ex);
                }
            }
            ++paramIndex;
        }
        for (String autowiredBeanName : autowiredBeanNames) {
            this.beanFactory.registerDependentBean(autowiredBeanName, beanName);
            if (!this.beanFactory.logger.isDebugEnabled()) continue;
            this.beanFactory.logger.debug((Object)("Autowiring by type from bean name '" + beanName + "' via " + methodType + " to bean named '" + autowiredBeanName + "'"));
        }
        if (resolveNecessary) {
            mbd.preparedConstructorArguments = args.preparedArguments;
        } else {
            mbd.resolvedConstructorArguments = args.arguments;
        }
        mbd.constructorArgumentsResolved = true;
        return args;
    }

    private Object[] resolvePreparedArguments(String beanName, RootBeanDefinition mbd, BeanWrapper bw, Member methodOrCtor) {
        Class<?>[] paramTypes = methodOrCtor instanceof Method ? ((Method)methodOrCtor).getParameterTypes() : ((Constructor)methodOrCtor).getParameterTypes();
        Object[] argsToResolve = mbd.preparedConstructorArguments;
        BeanWrapper converter = this.beanFactory.getCustomTypeConverter() != null ? this.beanFactory.getCustomTypeConverter() : bw;
        BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this.beanFactory, beanName, mbd, converter);
        Object[] resolvedArgs = new Object[argsToResolve.length];
        int argIndex = 0;
        while (argIndex < argsToResolve.length) {
            Object argValue = argsToResolve[argIndex];
            MethodParameter methodParam = MethodParameter.forMethodOrConstructor((Object)methodOrCtor, (int)argIndex);
            GenericTypeResolver.resolveParameterType((MethodParameter)methodParam, methodOrCtor.getDeclaringClass());
            if (argValue instanceof AutowiredArgumentMarker) {
                argValue = this.resolveAutowiredArgument(methodParam, beanName, null, converter);
            } else if (argValue instanceof BeanMetadataElement) {
                argValue = valueResolver.resolveValueIfNecessary("constructor argument", argValue);
            } else if (argValue instanceof String) {
                argValue = this.beanFactory.evaluateBeanDefinitionString((String)argValue, mbd);
            }
            Class<?> paramType = paramTypes[argIndex];
            try {
                resolvedArgs[argIndex] = converter.convertIfNecessary(argValue, paramType, methodParam);
            }
            catch (TypeMismatchException ex) {
                String methodType = methodOrCtor instanceof Constructor ? "constructor" : "factory method";
                throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, argIndex, paramType, "Could not convert " + methodType + " argument value of type [" + ObjectUtils.nullSafeClassName((Object)argValue) + "] to required type [" + paramType.getName() + "]: " + ex.getMessage());
            }
            ++argIndex;
        }
        return resolvedArgs;
    }

    protected Object resolveAutowiredArgument(MethodParameter param, String beanName, Set<String> autowiredBeanNames, TypeConverter typeConverter) {
        return this.beanFactory.resolveDependency(new DependencyDescriptor(param, true), beanName, autowiredBeanNames, typeConverter);
    }

    private static class ArgumentsHolder {
        public Object[] rawArguments;
        public Object[] arguments;
        public Object[] preparedArguments;

        public ArgumentsHolder(int size) {
            this.rawArguments = new Object[size];
            this.arguments = new Object[size];
            this.preparedArguments = new Object[size];
        }

        public ArgumentsHolder(Object[] args) {
            this.rawArguments = args;
            this.arguments = args;
            this.preparedArguments = args;
        }

        public int getTypeDifferenceWeight(Class[] paramTypes) {
            int typeDiffWeight = MethodInvoker.getTypeDifferenceWeight((Class[])paramTypes, (Object[])this.arguments);
            int rawTypeDiffWeight = MethodInvoker.getTypeDifferenceWeight((Class[])paramTypes, (Object[])this.rawArguments) - 1024;
            return rawTypeDiffWeight < typeDiffWeight ? rawTypeDiffWeight : typeDiffWeight;
        }

        public int getAssignabilityWeight(Class[] paramTypes) {
            int i = 0;
            while (i < paramTypes.length) {
                if (!ClassUtils.isAssignableValue((Class)paramTypes[i], (Object)this.arguments[i])) {
                    return Integer.MAX_VALUE;
                }
                ++i;
            }
            i = 0;
            while (i < paramTypes.length) {
                if (!ClassUtils.isAssignableValue((Class)paramTypes[i], (Object)this.rawArguments[i])) {
                    return 0x7FFFFDFF;
                }
                ++i;
            }
            return 0x7FFFFBFF;
        }
    }

    private static class AutowiredArgumentMarker {
        private AutowiredArgumentMarker() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructorPropertiesChecker {
        private ConstructorPropertiesChecker() {
        }

        public static String[] evaluateAnnotation(Constructor<?> candidate, int paramCount) {
            ConstructorProperties cp = candidate.getAnnotation(ConstructorProperties.class);
            if (cp != null) {
                String[] names = cp.value();
                if (names.length != paramCount) {
                    throw new IllegalStateException("Constructor annotated with @ConstructorProperties but not corresponding to actual number of parameters (" + paramCount + "): " + candidate);
                }
                return names;
            }
            return null;
        }
    }
}

