/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.annotations.Beta;
import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Equivalence;
import com.google.appengine.repackaged.com.google.common.base.EquivalenceWrapper;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.PairwiseEquivalence;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
@GwtCompatible
public final class Equivalences {
    private Equivalences() {
    }

    public static Equivalence<Object> equals() {
        return Impl.EQUALS;
    }

    public static Equivalence<Object> identity() {
        return Impl.IDENTITY;
    }

    @GwtCompatible(serializable=true)
    public static <T> Equivalence<Iterable<T>> pairwise(Equivalence<? super T> elementEquivalence) {
        return new PairwiseEquivalence<T>(elementEquivalence);
    }

    @GoogleInternal
    public static <T> EquivalenceWrapper<T> wrap(Equivalence<? super T> equivalence, @Nullable T reference) {
        return new EquivalenceWrapper<T>(equivalence, reference);
    }

    @GoogleInternal
    public static <A, B> Equivalence<A> compose(Equivalence<B> equiv, Function<A, ? extends B> function) {
        return new ComposedEquivalence(function, equiv);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @GoogleInternal
    private static final class ComposedEquivalence<A, B>
    implements Equivalence<A>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Function<A, ? extends B> function;
        private final Equivalence<B> equiv;

        private ComposedEquivalence(Function<A, ? extends B> function, Equivalence<B> equiv) {
            this.function = Preconditions.checkNotNull(function);
            this.equiv = Preconditions.checkNotNull(equiv);
        }

        @Override
        public boolean equivalent(A a, A b) {
            return this.equiv.equivalent(this.function.apply(a), this.function.apply(b));
        }

        @Override
        public int hash(A a) {
            return this.equiv.hash(this.function.apply(a));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Impl implements Equivalence<Object>
    {
        EQUALS{

            public boolean equivalent(@Nullable Object a, @Nullable Object b) {
                return a == null ? b == null : a.equals(b);
            }

            public int hash(@Nullable Object o) {
                return o == null ? 0 : o.hashCode();
            }
        }
        ,
        IDENTITY{

            public boolean equivalent(@Nullable Object a, @Nullable Object b) {
                return a == b;
            }

            public int hash(@Nullable Object o) {
                return System.identityHashCode(o);
            }
        };

    }
}

