/*
 * Decompiled with CFR 0.152.
 */
package siena.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import siena.ClassInfo;
import siena.Model;
import siena.Query;
import siena.SienaException;
import siena.Util;
import siena.remote.Common;
import siena.remote.Serializer;

public class RemoteStub {
    private ClassLoader classLoader;
    private Serializer serializer;
    private String key;

    public RemoteStub(Serializer serializer, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.serializer = serializer;
    }

    public Document process(Document doc) {
        try {
            String action;
            Element root = doc.getRootElement();
            if (this.key != null) {
                long time = Long.parseLong(root.attributeValue("time"));
                String hash = root.attributeValue("hash");
                if (!Util.sha1(time + this.key).equals(hash)) {
                    throw new SienaException("Invalid hash");
                }
                long diff = Math.abs(time - System.currentTimeMillis());
                if (diff > 10000L) {
                    throw new SienaException("Invalid time");
                }
            }
            if ("insert".equals(action = root.getName())) {
                Model obj = Common.parseEntity(root, this.classLoader);
                obj.insert();
                return this.simpleResponse(obj, true);
            }
            if ("update".equals(action)) {
                Common.parseEntity(root, this.classLoader).update();
            } else if ("delete".equals(action)) {
                Common.parseEntity(root, this.classLoader).delete();
            } else {
                if ("get".equals(action)) {
                    Model obj = Common.parseEntity(root, this.classLoader);
                    obj.get();
                    return this.simpleResponse(obj, false);
                }
                if ("query".equals(action)) {
                    String clazzName = root.attributeValue("class");
                    Class<?> clazz = Common.classForName(clazzName, this.classLoader);
                    Query<?> query = Model.all(clazz);
                    List list = root.elements();
                    for (Element element : list) {
                        String name = element.getName();
                        String fieldName = element.attributeValue("field");
                        if ("filter".equals(name)) {
                            Field field = clazz.getField(fieldName);
                            Object value = null;
                            if (element.hasContent()) {
                                value = ClassInfo.isModel(field.getType()) ? Common.parseEntity(element, this.classLoader) : Util.fromString(field.getType(), element.getText());
                            }
                            query.filter(fieldName, value);
                            continue;
                        }
                        if (!"order".equals(name)) continue;
                        query.order(fieldName);
                    }
                    String limit = root.attributeValue("limit");
                    String offset = root.attributeValue("offset");
                    List<?> result = null;
                    result = limit != null && offset != null ? query.fetch(Integer.parseInt(limit), Integer.parseInt(offset)) : (limit != null ? query.fetch(Integer.parseInt(limit)) : query.fetch());
                    Document response = DocumentHelper.createDocument();
                    Element r = response.addElement("result");
                    for (Model obj : result) {
                        Element object = r.addElement("object");
                        Common.fillRequestElement(obj, object, false);
                    }
                    return response;
                }
            }
        }
        catch (Throwable e) {
            return this.error(e);
        }
        return this.newDocument("ok");
    }

    private Document newDocument(String root) {
        return DocumentHelper.createDocument().addElement(root).getDocument();
    }

    private Document simpleResponse(Model obj, boolean ids) {
        Document response = this.newDocument("object");
        Common.fillRequestElement(obj, response.getRootElement(), ids);
        return response;
    }

    private Document error(Throwable e) {
        Document response = DocumentHelper.createDocument();
        Element root = response.addElement("error");
        root.addAttribute("class", e.getClass().getName());
        root.setText(e.getMessage());
        return response;
    }

    public void execute(InputStream in, OutputStream out) throws IOException {
        Document request = this.serializer.deserialize(in);
        Document response = this.process(request);
        this.serializer.serialize(response, out);
    }

    public void setKey(String key) {
        this.key = key;
    }
}

