/*
 * Decompiled with CFR 0.152.
 */
package siena;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import siena.Column;
import siena.Generator;
import siena.Id;
import siena.Json;
import siena.Model;
import siena.Query;
import siena.SienaException;
import siena.Table;

public class ClassInfo {
    private static Map<Class<?>, ClassInfo> infoClasses = new HashMap();
    public String tableName;
    public List<Field> keys = new ArrayList<Field>();
    public List<Field> insertFields = new ArrayList<Field>();
    public List<Field> updateFields = new ArrayList<Field>();
    public List<Field> generatedKeys = new ArrayList<Field>();
    public List<Field> allFields = new ArrayList<Field>();

    private ClassInfo(Class<?> clazz) {
        Field[] fields;
        this.tableName = this.getTableName(clazz);
        for (Field field : fields = clazz.getDeclaredFields()) {
            Class<?> type = field.getType();
            if (type == Class.class || type == Query.class || (field.getModifiers() & 0x80) == 128 || (field.getModifiers() & 8) == 8) continue;
            Id id = field.getAnnotation(Id.class);
            if (id != null) {
                if (id.value() == Generator.AUTO_INCREMENT) {
                    this.generatedKeys.add(field);
                } else {
                    this.insertFields.add(field);
                }
                this.keys.add(field);
            } else {
                this.updateFields.add(field);
                this.insertFields.add(field);
            }
            this.allFields.add(field);
        }
    }

    private String getTableName(Class<?> clazz) {
        Table t = clazz.getAnnotation(Table.class);
        if (t == null) {
            return clazz.getSimpleName();
        }
        return t.value();
    }

    public static String[] getColumnNames(Field field) {
        Column c = field.getAnnotation(Column.class);
        if (c != null && c.value().length > 0) {
            return c.value();
        }
        if (ClassInfo.isModel(field.getType())) {
            ClassInfo ci = ClassInfo.getClassInfo(field.getType());
            ArrayList<String> keys = new ArrayList<String>();
            for (Field key : ci.keys) {
                keys.addAll(Arrays.asList(ClassInfo.getColumnNames(key)));
            }
            return keys.toArray(new String[keys.size()]);
        }
        return new String[]{field.getName()};
    }

    public static boolean isModel(Class<?> type) {
        if (type.getSuperclass() == Model.class) {
            return true;
        }
        if (type.getName().startsWith("java.")) {
            return false;
        }
        if (type == Json.class) {
            return false;
        }
        return !ClassInfo.getClassInfo(type).keys.isEmpty();
    }

    public static boolean isId(Field field) {
        return field.getAnnotation(Id.class) != null;
    }

    public static Field getIdField(Class<?> clazz) {
        List<Field> keys = ClassInfo.getClassInfo(clazz).keys;
        if (keys.isEmpty()) {
            throw new SienaException("No valid @Id defined in class " + clazz.getName());
        }
        if (keys.size() > 1) {
            throw new SienaException("Multiple @Id defined in class " + clazz.getName());
        }
        return keys.get(0);
    }

    public static ClassInfo getClassInfo(Class<?> clazz) {
        ClassInfo ci = infoClasses.get(clazz);
        if (ci == null) {
            ci = new ClassInfo(clazz);
            infoClasses.put(clazz, ci);
        }
        return ci;
    }
}

