/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.conf.loader.annotation;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springmodules.validation.bean.conf.loader.annotation.ValidationAnnotationHandlerRegistry;
import org.springmodules.validation.bean.conf.loader.annotation.handler.ClassValidationAnnotationHandler;
import org.springmodules.validation.bean.conf.loader.annotation.handler.MethodValidationAnnotationHandler;
import org.springmodules.validation.bean.conf.loader.annotation.handler.PropertyValidationAnnotationHandler;
import org.springmodules.validation.util.cel.ConditionExpressionBased;
import org.springmodules.validation.util.cel.ConditionExpressionParser;
import org.springmodules.validation.util.cel.valang.ValangConditionExpressionParser;
import org.springmodules.validation.util.context.BasicContextAware;
import org.springmodules.validation.util.fel.FunctionExpressionBased;
import org.springmodules.validation.util.fel.FunctionExpressionParser;
import org.springmodules.validation.util.fel.parser.ValangFunctionExpressionParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleValidationAnnotationHandlerRegistry
extends BasicContextAware
implements ValidationAnnotationHandlerRegistry,
InitializingBean,
ConditionExpressionBased,
FunctionExpressionBased {
    private static final Log logger = LogFactory.getLog(SimpleValidationAnnotationHandlerRegistry.class);
    private List<ClassValidationAnnotationHandler> classHandlers = new ArrayList<ClassValidationAnnotationHandler>();
    private List<PropertyValidationAnnotationHandler> propertyHandlers = new ArrayList<PropertyValidationAnnotationHandler>();
    private List<MethodValidationAnnotationHandler> methodHandlers = new ArrayList<MethodValidationAnnotationHandler>();
    private boolean conditionExpressionParserSet = false;
    private ConditionExpressionParser conditionExpressionParser = new ValangConditionExpressionParser();
    private boolean functionExpressionParserSet = false;
    private FunctionExpressionParser functionExpressionParser = new ValangFunctionExpressionParser();

    @Override
    public ClassValidationAnnotationHandler findClassHanlder(Annotation annotation, Class clazz) {
        for (ClassValidationAnnotationHandler handler : this.classHandlers) {
            if (!handler.supports(annotation, clazz)) continue;
            return handler;
        }
        return null;
    }

    @Override
    public PropertyValidationAnnotationHandler findPropertyHanlder(Annotation annotation, Class clazz, PropertyDescriptor descriptor) {
        for (PropertyValidationAnnotationHandler handler : this.propertyHandlers) {
            if (!handler.supports(annotation, clazz, descriptor)) continue;
            return handler;
        }
        return null;
    }

    @Override
    public MethodValidationAnnotationHandler findMethodHandler(Annotation annotation, Class clazz, Method method) {
        for (MethodValidationAnnotationHandler handler : this.methodHandlers) {
            if (!handler.supports(annotation, clazz, method)) continue;
            return handler;
        }
        return null;
    }

    public void registerClassHandler(ClassValidationAnnotationHandler handler) {
        this.classHandlers.add(0, handler);
    }

    public void setExtraClassHandlers(List<ClassValidationAnnotationHandler> handlers) {
        Collections.reverse(handlers);
        for (ClassValidationAnnotationHandler handler : handlers) {
            this.registerClassHandler(handler);
        }
    }

    public void registerPropertyHandler(PropertyValidationAnnotationHandler handler) {
        this.propertyHandlers.add(0, handler);
    }

    public void setExtraPropertyHandlers(List<PropertyValidationAnnotationHandler> handlers) {
        Collections.reverse(handlers);
        for (PropertyValidationAnnotationHandler handler : handlers) {
            this.registerPropertyHandler(handler);
        }
    }

    public void registerMethodHandler(MethodValidationAnnotationHandler handler) {
        this.methodHandlers.add(0, handler);
    }

    public void setExtraMethodHandlers(List<MethodValidationAnnotationHandler> handlers) {
        Collections.reverse(handlers);
        for (MethodValidationAnnotationHandler handler : handlers) {
            this.registerMethodHandler(handler);
        }
    }

    @Override
    public void setConditionExpressionParser(ConditionExpressionParser conditionExpressionParser) {
        this.conditionExpressionParser = conditionExpressionParser;
    }

    @Override
    public void setFunctionExpressionParser(FunctionExpressionParser functionExpressionParser) {
        this.functionExpressionParser = functionExpressionParser;
    }

    public void afterPropertiesSet() throws Exception {
        this.findConditionExpressionParserInApplicationContext();
        this.findFunctionExpressionParserInApplicationContext();
        for (ClassValidationAnnotationHandler classValidationAnnotationHandler : this.classHandlers) {
            this.setExpressionParsers(classValidationAnnotationHandler);
            this.initLifecycle(classValidationAnnotationHandler);
        }
        for (PropertyValidationAnnotationHandler propertyValidationAnnotationHandler : this.propertyHandlers) {
            this.setExpressionParsers(propertyValidationAnnotationHandler);
            this.initLifecycle(propertyValidationAnnotationHandler);
        }
    }

    protected void setExpressionParsers(Object object) {
        if (ConditionExpressionBased.class.isInstance(object) && this.conditionExpressionParser != null) {
            ((ConditionExpressionBased)object).setConditionExpressionParser(this.conditionExpressionParser);
        }
        if (FunctionExpressionBased.class.isInstance(object) && this.functionExpressionParser != null) {
            ((FunctionExpressionBased)object).setFunctionExpressionParser(this.functionExpressionParser);
        }
    }

    protected void findConditionExpressionParserInApplicationContext() {
        if (this.conditionExpressionParserSet) {
            return;
        }
        ConditionExpressionParser parser = (ConditionExpressionParser)this.findObjectInApplicationContext(ConditionExpressionParser.class);
        if (parser == null) {
            return;
        }
        this.conditionExpressionParser = parser;
    }

    protected void findFunctionExpressionParserInApplicationContext() {
        if (this.functionExpressionParserSet) {
            return;
        }
        FunctionExpressionParser parser = (FunctionExpressionParser)this.findObjectInApplicationContext(FunctionExpressionParser.class);
        if (parser == null) {
            return;
        }
        this.functionExpressionParser = parser;
    }

    protected Object findObjectInApplicationContext(Class clazz) {
        if (this.applicationContext == null) {
            return null;
        }
        String[] names = this.applicationContext.getBeanNamesForType(clazz);
        if (names.length == 0) {
            return null;
        }
        if (names.length > 1) {
            logger.warn((Object)("Multiple bean of type '" + clazz.getName() + "' are defined in the application context." + "Only the first encountered one will be used"));
        }
        return this.applicationContext.getBean(names[0]);
    }
}

