package com.jispot.domain.model;

import siena.Column;
import siena.Filter;
import siena.Generator;
import siena.Id;
import siena.Max;
import siena.Model;
import siena.NotNull;
import siena.Query;
import siena.Table;
import siena.Text;
import siena.Unique;

@Table("application")
public class Application extends Model {

	@Id(Generator.AUTO_INCREMENT)
	public Long id;

    @Column("name")
    @Max(500)
    @NotNull
    @Unique("name_index")
    public String name;
    
    @Column("description")
    @Text
    public String description;
    
	@Filter("api_keys")
    public Query<Apikey> apiKeys;

    @Column("secret_key")
    @Max(1024)
    @NotNull
    public String secretKey;

    public static Query<Application> all() {
		return Model.all(Application.class);
	}

}
