/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.io.protocol.proto.ProtocolDescriptor;
import com.google.appengine.repackaged.com.google.io.protocol.proto.RPC_ServiceDescriptor;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolDB {
    private static final ProtocolDB EMPTY = new ProtocolDB();

    public static ProtocolDB getEmptyDB() {
        return EMPTY;
    }

    public static ProtocolDB merge(ProtocolDB a, ProtocolDB b) {
        return new MergedProtocolDB(a, b);
    }

    public ProtocolDescriptor find(String name) {
        return null;
    }

    public ProtocolDescriptor findByTypeId(int typeId) {
        return null;
    }

    public Set<String> findByFileName(String fileName) {
        return ImmutableSet.of();
    }

    public RPC_ServiceDescriptor findService(String name) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MergedProtocolDB
    extends ProtocolDB {
        private final ProtocolDB a;
        private final ProtocolDB b;

        MergedProtocolDB(ProtocolDB a, ProtocolDB b) {
            Preconditions.checkNotNull(a, "a");
            Preconditions.checkNotNull(b, "b");
            this.a = a;
            this.b = b;
        }

        @Override
        public ProtocolDescriptor find(String name) {
            ProtocolDescriptor descriptor = this.a.find(name);
            if (descriptor == null) {
                descriptor = this.b.find(name);
            }
            return descriptor;
        }

        @Override
        public Set<String> findByFileName(String fileName) {
            return Sets.union(this.a.findByFileName(fileName), this.b.findByFileName(fileName));
        }

        @Override
        public RPC_ServiceDescriptor findService(String name) {
            RPC_ServiceDescriptor descriptor = this.a.findService(name);
            if (descriptor == null) {
                descriptor = this.b.findService(name);
            }
            return descriptor;
        }
    }
}

