/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.expression;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreElementContainer;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.IdentifierType;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.StatementMappingIndex;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.ReferenceMapping;

public class ExpressionHelper {
    public static void selectMapping(StatementMappingIndex stmtMapping, QueryExpression qs, DatastoreIdentifier tableIdentifier, ClassLoaderResolver clr) {
        if (stmtMapping == null) {
            return;
        }
        JavaTypeMapping m = stmtMapping.getMapping();
        if (m == null) {
            return;
        }
        AbstractMemberMetaData fmd = m.getMemberMetaData();
        if (m.getNumberOfDatastoreFields() > 0) {
            int[] columnNumbersByField = tableIdentifier != null ? qs.select(tableIdentifier, m, true) : qs.select(m, true);
            stmtMapping.setColumnPositions(columnNumbersByField);
        } else {
            int relationType = fmd.getRelationType(clr);
            if (relationType == 2 && fmd.getMappedBy() != null) {
                int[] colNums = null;
                MappedStoreManager storeMgr = qs.getStoreManager();
                JavaTypeMapping[] sourceMappings = null;
                DatastoreClass[] sourceTables = null;
                if (m instanceof ReferenceMapping) {
                    JavaTypeMapping[] refMappings = ((ReferenceMapping)m).getJavaTypeMapping();
                    sourceTables = new DatastoreClass[refMappings.length];
                    sourceMappings = new JavaTypeMapping[refMappings.length];
                    for (int j = 0; j < refMappings.length; ++j) {
                        sourceTables[j] = storeMgr.getDatastoreClass(refMappings[j].getType(), clr);
                        sourceMappings[j] = sourceTables[j].getMemberMapping(fmd.getMappedBy());
                    }
                } else {
                    sourceTables = new DatastoreClass[1];
                    sourceMappings = new JavaTypeMapping[1];
                    sourceTables[0] = storeMgr.getDatastoreClass(fmd.getTypeName(), clr);
                    sourceMappings[0] = sourceTables[0].getMemberMapping(fmd.getMappedBy());
                }
                for (int j = 0; j < sourceMappings.length; ++j) {
                    ScalarExpression targetExpr;
                    DatastoreIdentifier sourceTableIdentifier = storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, "SOURCECLASS" + fmd.getAbsoluteFieldNumber() + "_" + j);
                    LogicSetExpression sourceTableExpr = qs.newTableExpression(sourceTables[j], sourceTableIdentifier, true)[0];
                    ScalarExpression sourceExpr = sourceMappings[j].newScalarExpression(qs, sourceTableExpr);
                    if (tableIdentifier != null) {
                        LogicSetExpression targetTableExpr = qs.getTableExpression(tableIdentifier) == null ? qs.newTableExpression(m.getDatastoreContainer(), tableIdentifier) : qs.getTableExpression(tableIdentifier);
                        targetExpr = m.getDatastoreContainer().getIDMapping().newScalarExpression(qs, targetTableExpr);
                    } else {
                        targetExpr = m.getDatastoreContainer().getIDMapping().newScalarExpression(qs, qs.getMainTableExpression());
                    }
                    qs.leftOuterJoin(sourceExpr, targetExpr, sourceTableExpr, true, true);
                    int[] columnNumbersByField = qs.select(sourceTableIdentifier, sourceTables[j].getIDMapping(), true);
                    if (sourceMappings.length == 1) {
                        colNums = columnNumbersByField;
                        continue;
                    }
                    if (colNums != null) {
                        int k;
                        int[] tmpColNums = colNums;
                        colNums = new int[tmpColNums.length + columnNumbersByField.length];
                        for (k = 0; k < tmpColNums.length; ++k) {
                            colNums[k] = tmpColNums[k];
                        }
                        for (k = 0; k < columnNumbersByField.length; ++k) {
                            colNums[tmpColNums.length + k] = columnNumbersByField[k];
                        }
                        tmpColNums = null;
                        continue;
                    }
                    colNums = new int[columnNumbersByField.length];
                    for (int k = 0; k < columnNumbersByField.length; ++k) {
                        colNums[k] = columnNumbersByField[k];
                    }
                }
                stmtMapping.setColumnPositions(colNums);
            } else if (relationType == 6) {
                AbstractMemberMetaData[] relatedMmds = fmd.getRelatedMemberMetaData(clr);
                if (fmd.getJoinMetaData() != null || relatedMmds[0].getJoinMetaData() != null) {
                    MappedStoreManager storeMgr = qs.getStoreManager();
                    DatastoreContainerObject joinTable = storeMgr.getDatastoreContainerObject(relatedMmds[0]);
                    DatastoreElementContainer collTable = (DatastoreElementContainer)joinTable;
                    JavaTypeMapping referenceMapping = collTable.getElementMapping();
                    JavaTypeMapping selectMapping = collTable.getOwnerMapping();
                    DatastoreContainerObject mainTable = qs.getMainTableExpression().getMainTable();
                    if (!mainTable.equals(joinTable)) {
                        DatastoreIdentifier joinTableIdentifier = storeMgr.getIdentifierFactory().newIdentifier(IdentifierType.TABLE, "JOINTABLE" + fmd.getAbsoluteFieldNumber());
                        LogicSetExpression table_expr_sub = qs.newTableExpression(joinTable, joinTableIdentifier, true)[0];
                        ScalarExpression subExpr = referenceMapping.newScalarExpression(qs, table_expr_sub);
                        ScalarExpression schExpr = null;
                        if (tableIdentifier != null) {
                            LogicSetExpression targetTableExpr = qs.getTableExpression(tableIdentifier) == null ? qs.newTableExpression(m.getDatastoreContainer(), tableIdentifier) : qs.getTableExpression(tableIdentifier);
                            schExpr = m.getDatastoreContainer().getIDMapping().newScalarExpression(qs, targetTableExpr);
                        } else {
                            schExpr = m.getDatastoreContainer().getIDMapping().newScalarExpression(qs, qs.getMainTableExpression());
                        }
                        qs.leftOuterJoin(subExpr, schExpr, table_expr_sub, true, true);
                        int[] columnNumbersByField = qs.select(joinTableIdentifier, selectMapping, true);
                        stmtMapping.setColumnPositions(columnNumbersByField);
                    } else {
                        int[] columnNumbersByField = qs.select(selectMapping, true);
                        stmtMapping.setColumnPositions(columnNumbersByField);
                    }
                }
            }
        }
    }
}

