/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.jdbc.internal;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.cloud.sql.jdbc.internal.AbstractSqlClient;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.cloud.sql.jdbc.internal.SqlRpc;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.cloud.sql.jdbc.internal.Util;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.CloseConnectionRequest;
import com.google.protos.cloud.sql.CloseConnectionResponse;
import com.google.protos.cloud.sql.ExecOpRequest;
import com.google.protos.cloud.sql.ExecOpResponse;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.ExecResponse;
import com.google.protos.cloud.sql.MetadataRequest;
import com.google.protos.cloud.sql.MetadataResponse;
import com.google.protos.cloud.sql.OpenConnectionRequest;
import com.google.protos.cloud.sql.OpenConnectionResponse;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlProtoClient
extends AbstractSqlClient {
    private static final Logger LOG = Logger.getLogger(SqlProtoClient.class.getName());
    private final SqlRpc rpc;

    public SqlProtoClient(String instance, SqlRpc stub) {
        super(instance);
        this.rpc = Util.checkNotNull(stub, "stub can not be null");
        LOG.log(Level.FINE, "Created client for instance: {0}", instance);
    }

    @Override
    public OpenConnectionResponse openConnection(SqlRpcOptions options, Url url) throws SQLException {
        LOG.log(Level.FINE, "Executing OpenConnection: {0} at {1}/{2}", new Object[]{url.getUser(), url.getInstance(), url.getDatabase()});
        OpenConnectionRequest request = this.createConnectRequest(url);
        OpenConnectionResponse response = this.rpc.openConnection(options, request);
        LOG.log(Level.FINEST, "Stubby response: {0}", response);
        return SqlProtoClient.check(response);
    }

    @Override
    public CloseConnectionResponse closeConnection(SqlRpcOptions options, ByteString connectionId) throws SQLException {
        LOG.log(Level.FINE, "Executing CloseConnection: {0}", connectionId);
        CloseConnectionRequest request = this.createReleaseRequest(connectionId);
        CloseConnectionResponse response = this.rpc.closeConnection(options, request);
        LOG.log(Level.FINEST, "Stubby response: {0}", response);
        return SqlProtoClient.check(response);
    }

    @Override
    public ExecResponse executeSql(SqlRpcOptions options, ByteString connectionId, String sql) throws SQLException {
        return this.executeSql(options, connectionId, sql, Collections.<Client.BindVariableProto>emptyList());
    }

    @Override
    public ExecResponse executeSql(SqlRpcOptions options, ByteString connectionId, String sql, List<Client.BindVariableProto> bindParameters) throws SQLException {
        LOG.log(Level.FINE, "Executing SQL: {0}", sql);
        ExecRequest request = this.createExecRequest(options, connectionId, sql, bindParameters);
        ExecResponse response = new ExecHelper(options, request).run();
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return SqlProtoClient.check(response);
    }

    @Override
    public ExecResponse executeBatchSql(SqlRpcOptions options, ByteString connectionId, String sql, List<List<Client.BindVariableProto>> batchBindParameters) throws SQLException {
        LOG.log(Level.FINE, "Executing Batch SQL: {0}", sql);
        ExecRequest request = this.createBatchExecRequest(options, connectionId, sql, batchBindParameters);
        ExecResponse response = new ExecHelper(options, request).run();
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return SqlProtoClient.check(response);
    }

    @Override
    public ExecResponse executeBatchSql(SqlRpcOptions options, ByteString connectionId, List<String> batchSql) throws SQLException {
        LOG.log(Level.FINE, "Executing Batch SQL: {0}", batchSql);
        ExecRequest request = this.createBatchExecRequest(options, connectionId, batchSql);
        ExecResponse response = new ExecHelper(options, request).run();
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return SqlProtoClient.check(response);
    }

    @Override
    public ExecResponse executeNext(SqlRpcOptions options, ByteString connectionId, long statementId) throws SQLException {
        LOG.log(Level.FINE, "Executing Next: {0}", statementId);
        ExecRequest request = this.createExecNextRequest(options, connectionId, statementId);
        ExecResponse response = new ExecHelper(options, request).run();
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return SqlProtoClient.check(response);
    }

    @Override
    public ExecOpResponse executeOperation(SqlRpcOptions options, ByteString connectionId, Client.OpProto op) throws SQLException {
        LOG.log(Level.FINE, "Executing Operation: {0}", op.getType().name());
        ExecOpRequest request = this.createExecOpRequest(connectionId, op);
        ExecOpResponse response = this.rpc.execOp(options, request);
        LOG.log(Level.FINEST, "Stubby response = {0}", response);
        return SqlProtoClient.check(response);
    }

    @Override
    public final MetadataResponse getMetadata(SqlRpcOptions options, ByteString connectionId, Client.MetadataType metadataType, List<Client.BindVariableProto> bindParameters) throws SQLException {
        if (!LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINE, "Executing metadata request for type: {0}; params={1}", new Object[]{metadataType, bindParameters.toString()});
        }
        MetadataRequest request = this.createMetadataRequest(connectionId, metadataType, bindParameters);
        LOG.log(Level.FINEST, "Executing metadata request request = {0}", request.toString());
        MetadataResponse response = this.rpc.getMetadata(options, request);
        LOG.log(Level.FINEST, "Stubby response: {0}", response);
        return SqlProtoClient.check(response);
    }

    @Override
    public SqlRpc getRpc() {
        return this.rpc;
    }

    private static OpenConnectionResponse check(OpenConnectionResponse response) throws SQLException {
        if (response.hasSqlException()) {
            throw Exceptions.newSqlException(response.getSqlException());
        }
        return response;
    }

    private static CloseConnectionResponse check(CloseConnectionResponse response) throws SQLException {
        if (response.hasSqlException()) {
            throw Exceptions.newSqlException(response.getSqlException());
        }
        return response;
    }

    private static ExecResponse check(ExecResponse response) throws SQLException {
        if (response.hasSqlException()) {
            throw Exceptions.newSqlException(response.getSqlException());
        }
        return response;
    }

    private static ExecOpResponse check(ExecOpResponse response) throws SQLException {
        if (response.hasSqlException()) {
            throw Exceptions.newSqlException(response.getSqlException());
        }
        return response;
    }

    private static MetadataResponse check(MetadataResponse response) throws SQLException {
        if (response.hasSqlException()) {
            throw Exceptions.newSqlException(response.getSqlException());
        }
        return response;
    }

    private static boolean needToRetry(ExecResponse execResponse) {
        if (!execResponse.hasSqlException()) {
            return false;
        }
        Client.SqlException sqlException = execResponse.getSqlException();
        return SqlProtoClient.needToRetryFirstExecRequest(sqlException.getApplicationErrorCode());
    }

    private static boolean needToRetry(ExecOpResponse execOpResponse) {
        if (!execOpResponse.hasSqlException()) {
            return false;
        }
        Client.SqlException sqlException = execOpResponse.getSqlException();
        return SqlProtoClient.needToRetrySubsqeuentExecOpRequest(sqlException.getApplicationErrorCode());
    }

    private static boolean needToRetryFirstExecRequest(int applicationErrorCode) {
        return applicationErrorCode == 1002;
    }

    private static boolean needToRetrySubsqeuentExecOpRequest(int applicationErrorCode) {
        return applicationErrorCode == 1038;
    }

    private static ExecOpRequest toRetryRequest(ExecRequest request) {
        return ExecOpRequest.newBuilder().setInstance(request.getInstance()).setConnectionId(request.getConnectionId()).setOp(Client.OpProto.newBuilder().setType(Client.OpProto.OpType.RETRY).setRequestId(request.getRequestId()).build()).build();
    }

    private static Client.SqlException toSqlException(Client.RpcErrorProto error) {
        return Client.SqlException.newBuilder().setCode(0).setApplicationErrorCode(error.getErrorCode()).setMessage(error.getErrorMessage()).build();
    }

    private static ExecResponse toCachedExecResponse(ExecOpResponse retryResponse) throws SQLException {
        if (!retryResponse.hasCachedPayload()) {
            throw Exceptions.newSqlException("Missing cached payload in retry response.");
        }
        try {
            return ((ExecResponse.Builder)ExecResponse.newBuilder().mergeFrom(retryResponse.getCachedPayload())).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw Exceptions.newSqlException("Cached payload is not of the correct type.");
        }
    }

    class ExecHelper {
        private final ExecRequest request;
        private final SqlRpcOptions options;
        private long deadlineMillis;

        ExecHelper(SqlRpcOptions options, ExecRequest request) {
            this.options = options;
            this.request = request;
        }

        ExecResponse run() throws SQLException {
            this.deadlineMillis = System.currentTimeMillis() + this.options.getQueryTimeOutMillis();
            ExecResponse response = null;
            try {
                response = SqlProtoClient.this.rpc.exec(this.options, this.request);
            }
            catch (SQLException e) {
                if (SqlProtoClient.needToRetryFirstExecRequest(e.getErrorCode())) {
                    return this.retry();
                }
                throw e;
            }
            Util.checkNotNull(response, "ExecResponse cannot be null.");
            if (SqlProtoClient.needToRetry(response)) {
                return this.retry();
            }
            return response;
        }

        private void waitBeforeRetry() {
            long millisToWait = this.options.getRetryIntervalMillis();
            if (System.currentTimeMillis() + millisToWait >= this.deadlineMillis) {
                millisToWait = this.deadlineMillis - System.currentTimeMillis();
            }
            try {
                Thread.sleep(millisToWait);
            }
            catch (InterruptedException e) {
                return;
            }
        }

        private ExecResponse retry() throws SQLException {
            while (System.currentTimeMillis() < this.deadlineMillis) {
                this.waitBeforeRetry();
                ExecOpResponse response = null;
                try {
                    response = SqlProtoClient.this.rpc.execOp(this.options, SqlProtoClient.toRetryRequest(this.request));
                }
                catch (SQLException e) {
                    if (SqlProtoClient.needToRetrySubsqeuentExecOpRequest(e.getErrorCode())) continue;
                    throw e;
                }
                Util.checkNotNull(response, "ExecOpResponse cannot be null.");
                if (SqlProtoClient.needToRetry(response)) continue;
                if (response.hasCachedRpcError()) {
                    throw Exceptions.newSqlException(SqlProtoClient.toSqlException(response.getCachedRpcError()));
                }
                return SqlProtoClient.toCachedExecResponse(response);
            }
            throw Exceptions.newTimeoutException();
        }
    }
}

