/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.identity;

import java.util.Map;
import java.util.WeakHashMap;
import org.datanucleus.ClassConstants;
import org.datanucleus.ObjectManager;
import org.datanucleus.identity.DatastoreUniqueOID;
import org.datanucleus.identity.OID;
import org.datanucleus.identity.OIDImpl;
import org.datanucleus.util.ClassUtils;

public class OIDFactory {
    private static Map oids = new WeakHashMap();

    private OIDFactory() {
    }

    public static OID getInstance(ObjectManager om, String className, Object value) {
        Class oidClass = om.getOMFContext().getDatastoreIdentityClass();
        String key = oidClass.getName() + "#" + className + "#" + value.toString();
        OID oid = (OID)oids.get(key);
        if (oid == null) {
            oid = oidClass == ClassConstants.OID_IMPL ? new OIDImpl(className, value) : (OID)ClassUtils.newInstance(oidClass, new Class[]{String.class, Object.class}, new Object[]{className, value});
            oids.put(key, oid);
        }
        return oid;
    }

    public static OID getInstance(ObjectManager om, long value) {
        Class oidClass = om.getOMFContext().getDatastoreIdentityClass();
        String key = oidClass.getName() + "#" + value;
        OID oid = (OID)oids.get(key);
        if (oid == null) {
            oid = oidClass == DatastoreUniqueOID.class ? new DatastoreUniqueOID(value) : (OID)ClassUtils.newInstance(oidClass, new Class[]{Long.class}, new Object[]{new Long(value)});
            oids.put(key, oid);
        }
        return oid;
    }

    public static OID getInstance(ObjectManager om, String oidString) {
        Class oidClass = om.getOMFContext().getDatastoreIdentityClass();
        String key = oidClass.getName() + "#" + oidString;
        OID oid = (OID)oids.get(key);
        if (oid == null) {
            oid = oidClass == ClassConstants.OID_IMPL ? new OIDImpl(oidString) : (OID)ClassUtils.newInstance(oidClass, new Class[]{String.class}, new Object[]{oidString});
            oids.put(key, oid);
        }
        return oid;
    }
}

