/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus;

import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.datanucleus.ObjectManager;
import org.datanucleus.TransactionImpl;
import org.datanucleus.transaction.NucleusTransactionException;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class JTAJCATransactionImpl
extends TransactionImpl
implements Synchronization {
    private TransactionManager tm;
    private Transaction jtaTx;
    private boolean markedForRollback = false;

    JTAJCATransactionImpl(ObjectManager om) {
        super(om);
        this.joinTransaction();
    }

    public boolean isActive() {
        boolean isActive = super.isActive();
        if (isActive) {
            return true;
        }
        this.joinTransaction();
        return this.active;
    }

    private synchronized void joinTransaction() {
        if (this.active) {
            return;
        }
        try {
            if (this.tm == null) {
                this.tm = this.obtainTransactionManager();
            }
            this.jtaTx = this.tm.getTransaction();
            if (this.jtaTx != null && this.jtaTx.getStatus() == 0) {
                if (!this.om.getOMFContext().getPersistenceConfiguration().isJcaMode()) {
                    this.jtaTx.registerSynchronization((Synchronization)this);
                }
                this.begin();
            } else if (this.markedForRollback) {
                this.rollback();
                this.markedForRollback = false;
            }
        }
        catch (SystemException se) {
            throw new NucleusTransactionException(LOCALISER.msg("015026"), se);
        }
        catch (RollbackException e) {
            NucleusLogger.TRANSACTION.error("Exception while joining transaction: " + StringUtils.getStringFromStackTrace(e));
        }
    }

    private TransactionManager obtainTransactionManager() {
        TransactionManager tm = this.om.getOMFContext().getJtaTransactionManager();
        if (tm == null) {
            throw new NucleusTransactionException(LOCALISER.msg("015030"));
        }
        return tm;
    }

    public void beforeCompletion() {
        try {
            this.internalPreCommit();
        }
        catch (Throwable th) {
            NucleusLogger.TRANSACTION.error("Exception flushing work in JTA transaction. Mark for rollback", th);
            try {
                this.jtaTx.setRollbackOnly();
            }
            catch (Exception e) {
                NucleusLogger.TRANSACTION.fatal("Cannot mark transaction for rollback after exception in beforeCompletion. PersistenceManager might be in inconsistent state", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterCompletion(int status) {
        try {
            block6: {
                try {
                    if (status == 4) {
                        this.rollback();
                        break block6;
                    }
                    if (status == 3) {
                        this.internalPostCommit();
                        break block6;
                    }
                    NucleusLogger.TRANSACTION.fatal("Received unexpected transaction status + " + status);
                }
                catch (Throwable th) {
                    NucleusLogger.TRANSACTION.error("Exception during afterCompletion in JTA transaction. PersistenceManager might be in inconsistent state");
                    Object var4_3 = null;
                    this.jtaTx = null;
                }
            }
            Object var4_2 = null;
            this.jtaTx = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.jtaTx = null;
            throw throwable;
        }
    }
}

